/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.storage.httprecord;

import io.datarouter.binarydto.codec.BinaryDtoIndexedCodec;
import io.datarouter.bytes.Codec;
import io.datarouter.exception.dto.HttpRequestRecordBinaryDto;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.properties.EnvironmentName;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseRedundantDaoParams;
import io.datarouter.storage.node.factory.QueueNodeFactory;
import io.datarouter.storage.node.op.raw.BlobQueueStorage;
import io.datarouter.storage.queue.consumer.BlobQueueConsumer;
import io.datarouter.storage.tag.Tag;
import io.datarouter.virtualnode.redundant.RedundantBlobQueueStorageNode;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;

@Singleton
public class HttpRequestRecordQueueDao
extends BaseDao {
    private final BlobQueueStorage.BlobQueueStorageNode<HttpRequestRecordBinaryDto> node;

    @Inject
    public HttpRequestRecordQueueDao(Datarouter datarouter, HttpRequestRecordQueueDaoParams params, QueueNodeFactory queueNodeFactory, EnvironmentName environmentNameSupplier) {
        super(datarouter);
        String namespace = environmentNameSupplier.deprecatedIsProduction() ? "shared" : String.valueOf(environmentNameSupplier.get()) + "-shared";
        this.node = (BlobQueueStorage.BlobQueueStorageNode)Scanner.of((Iterable)params.clientIds).map(clientId -> queueNodeFactory.createBlobQueue(clientId, "HttpRequestBinaryDto", (Codec)BinaryDtoIndexedCodec.of(HttpRequestRecordBinaryDto.class)).withNamespace(namespace).withTag(Tag.DATAROUTER).withAgeMonitoring(false).build()).listTo(RedundantBlobQueueStorageNode::makeIfMulti);
        datarouter.register(this.node);
    }

    public void combineAndPut(Scanner<HttpRequestRecordBinaryDto> dtos) {
        this.node.combineAndPut(dtos);
    }

    public BlobQueueConsumer<HttpRequestRecordBinaryDto> getBlobQueueConsumer() {
        return new BlobQueueConsumer(this.node);
    }

    public static class HttpRequestRecordQueueDaoParams
    extends BaseRedundantDaoParams {
        public HttpRequestRecordQueueDaoParams(List<ClientId> clientIds) {
            super(clientIds);
        }
    }
}

