/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.storage.taskexecutorrecord;

import io.datarouter.binarydto.codec.BinaryDtoIndexedCodec;
import io.datarouter.bytes.Codec;
import io.datarouter.exception.dto.TaskExecutorRecordBinaryDto;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.properties.EnvironmentName;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseRedundantDaoParams;
import io.datarouter.storage.node.factory.QueueNodeFactory;
import io.datarouter.storage.node.op.raw.BlobQueueStorage;
import io.datarouter.storage.queue.consumer.BlobQueueConsumer;
import io.datarouter.storage.tag.Tag;
import io.datarouter.virtualnode.redundant.RedundantBlobQueueStorageNode;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;

@Singleton
public class TaskExecutorRecordQueueDao
extends BaseDao {
    private final BlobQueueStorage.BlobQueueStorageNode<TaskExecutorRecordBinaryDto> node;

    @Inject
    public TaskExecutorRecordQueueDao(Datarouter datarouter, TaskExecutorRecordQueueDaoParams params, QueueNodeFactory queueNodeFactory, EnvironmentName environmentNameSupplier) {
        super(datarouter);
        String namespace = environmentNameSupplier.deprecatedIsProduction() ? "shared" : String.valueOf(environmentNameSupplier.get()) + "-shared";
        this.node = (BlobQueueStorage.BlobQueueStorageNode)Scanner.of((Iterable)params.clientIds).map(clientId -> queueNodeFactory.createBlobQueue(clientId, "TaskExecutorRecordBinaryDto", (Codec)BinaryDtoIndexedCodec.of(TaskExecutorRecordBinaryDto.class)).withNamespace(namespace).withTag(Tag.DATAROUTER).build()).listTo(RedundantBlobQueueStorageNode::makeIfMulti);
        datarouter.register(this.node);
    }

    public void combineAndPut(Scanner<TaskExecutorRecordBinaryDto> dtos) {
        this.node.combineAndPut(dtos);
    }

    public BlobQueueConsumer<TaskExecutorRecordBinaryDto> getBlobQueueConsumer() {
        return new BlobQueueConsumer(this.node);
    }

    public static class TaskExecutorRecordQueueDaoParams
    extends BaseRedundantDaoParams {
        public TaskExecutorRecordQueueDaoParams(List<ClientId> clientIds) {
            super(clientIds);
        }
    }
}

