/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.utils;

import io.datarouter.exception.utils.nameparser.ExceptionNameParser;
import io.datarouter.exception.utils.nameparser.ExceptionNameParserRegistry;
import io.datarouter.exception.utils.nameparser.ExceptionSnapshot;
import io.datarouter.inject.DatarouterInjector;
import io.datarouter.scanner.OptionalScanner;
import io.datarouter.scanner.Scanner;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@Singleton
public class ExceptionDetailsDetector {
    @Inject
    private ExceptionNameParserRegistry registry;
    @Inject
    private DatarouterInjector injector;

    public ExceptionRecorderDetails detect(Throwable wholeException, String callOrigin, Set<String> highlights) {
        return this.detect(new ExceptionSnapshot(wholeException), callOrigin, highlights);
    }

    public ExceptionRecorderDetails detect(ExceptionSnapshot snapshot, String callOrigin, Set<String> highlights) {
        ExceptionSnapshot.ExceptionCauseSnapshot exception;
        Optional<ExceptionSnapshot.StackTraceElementSnapshot> stackTraceElement;
        Optional<ExceptionSnapshot.ExceptionCauseSnapshot> rootCause = snapshot.getRootCause();
        Optional<String> parsedName = Optional.empty();
        Optional parserAndCauseOpt = Scanner.of(this.registry.getNameParserClasses()).map(arg_0 -> ((DatarouterInjector)this.injector).getInstance(arg_0)).map(ExceptionNameParser.class::cast).map(parser -> parser.getCausesFromType(snapshot).map(cause -> new ExceptionParserAndOutput((ExceptionNameParser)parser, (List<ExceptionSnapshot.ExceptionCauseSnapshot>)cause))).concat(OptionalScanner::of).findFirst();
        if (parserAndCauseOpt.isPresent()) {
            ExceptionParserAndOutput parserAndCause = (ExceptionParserAndOutput)parserAndCauseOpt.get();
            rootCause = Optional.of(parserAndCause.output().get(0));
            ExceptionNameParser exceptionWithParser = parserAndCause.parser();
            parsedName = exceptionWithParser.parseExceptionName(parserAndCause.output());
        }
        if ((stackTraceElement = ExceptionDetailsDetector.searchClassName(exception = rootCause.orElse(new ExceptionSnapshot.ExceptionCauseSnapshot(null, null, null, List.of())), highlights)).isEmpty()) {
            stackTraceElement = exception.stackTraces.stream().findFirst();
        }
        return new ExceptionRecorderDetails(exception, stackTraceElement, parsedName, callOrigin);
    }

    private static Optional<ExceptionSnapshot.StackTraceElementSnapshot> searchClassName(ExceptionSnapshot.ExceptionCauseSnapshot cause, Set<String> highlights) {
        return Scanner.of(cause.stackTraces).include(element -> Scanner.of((Iterable)highlights).anyMatch(highlight -> stackTraceElementSnapshot.declaringClass.contains((CharSequence)highlight))).findFirst();
    }

    public record ExceptionParserAndOutput(ExceptionNameParser parser, List<ExceptionSnapshot.ExceptionCauseSnapshot> output) {
    }

    public static class ExceptionRecorderDetails {
        public final String className;
        public final String methodName;
        public final String type;
        public final int lineNumber;
        public final String detailsMessage;
        public final String parsedName;

        private ExceptionRecorderDetails(ExceptionSnapshot.ExceptionCauseSnapshot rootCause, Optional<ExceptionSnapshot.StackTraceElementSnapshot> element, Optional<String> parsedName, String callOrigin) {
            this.className = element.map(e -> e.declaringClass).orElse("noClass");
            this.methodName = element.map(e -> e.methodName).orElse("noMethod");
            this.type = rootCause.typeName;
            this.lineNumber = element.map(e -> e.lineNumber).orElse(0);
            this.detailsMessage = rootCause.detailMessage;
            this.parsedName = parsedName.orElse(ExceptionRecorderDetails.getDefaultName(this.type, this.className, callOrigin));
        }

        public static String getDefaultName(String type, String className, String callOrigin) {
            callOrigin = Optional.ofNullable(callOrigin).orElse(className);
            return String.format("%s at %s in %s", ExceptionRecorderDetails.getSimpleClassName(type), ExceptionRecorderDetails.getSimpleClassName(className), ExceptionRecorderDetails.getSimpleClassName(callOrigin));
        }

        private static String getSimpleClassName(String fullClassName) {
            return Optional.ofNullable(fullClassName).map(ExceptionRecorderDetails::parseName).orElse("");
        }

        private static String parseName(String fullClassName) {
            String[] tokens = fullClassName.split("\\.");
            if (tokens.length < 2) {
                return fullClassName;
            }
            if (Character.isUpperCase(tokens[tokens.length - 1].charAt(0))) {
                return tokens[tokens.length - 1];
            }
            return String.valueOf(tokens[tokens.length - 2]) + "." + tokens[tokens.length - 1];
        }
    }
}

