/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.utils.nameparser;

import io.datarouter.exception.utils.nameparser.ExceptionSnapshot;
import io.datarouter.scanner.OptionalScanner;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class ExceptionNameParser {
    protected abstract Optional<String> parse(ExceptionSnapshot.ExceptionCauseSnapshot var1);

    protected abstract List<Class<? extends Throwable>> matchingTypes();

    protected abstract Optional<Map<Class<? extends Throwable>, String>> stackTraceByType();

    public Set<String> getMatchingTypeClassNames() {
        return (Set)Scanner.of(this.matchingTypes()).map(Class::getName).collect(Collectors.toSet());
    }

    public Optional<String> parseExceptionName(List<ExceptionSnapshot.ExceptionCauseSnapshot> causes) {
        return Scanner.of(causes).map(this::parse).concat(OptionalScanner::of).findFirst();
    }

    public Optional<List<ExceptionSnapshot.ExceptionCauseSnapshot>> getCausesFromType(ExceptionSnapshot exception) {
        if (exception == null || !this.isCauseFromTypes(exception)) {
            return Optional.empty();
        }
        Set<String> mathcingClasses = this.getMatchingTypeClassNames();
        return Optional.of(Scanner.of(exception.causes).include(cause -> mathcingClasses.contains(cause.typeName)).list());
    }

    private boolean isCauseFromTypes(ExceptionSnapshot exception) {
        List allTypeNames = Scanner.of(exception.causes).map(cause -> cause.typeName).list();
        boolean hasAllMatchingTypes = allTypeNames.containsAll(this.getMatchingTypeClassNames());
        if (this.stackTraceByType().isEmpty() || !hasAllMatchingTypes) {
            return hasAllMatchingTypes;
        }
        Map stackTraceByTypeName = Scanner.of(this.stackTraceByType().get().entrySet()).toMap(entry -> ((Class)entry.getKey()).getName(), Map.Entry::getValue);
        Optional matchedCause = Scanner.of(exception.causes).include(cause -> stackTraceByTypeName.containsKey(cause.typeName)).findFirst();
        if (matchedCause.isEmpty()) {
            return false;
        }
        String matchedClassAndMethodInStackTrace = (String)stackTraceByTypeName.get(((ExceptionSnapshot.ExceptionCauseSnapshot)matchedCause.get()).typeName);
        return Scanner.of(((ExceptionSnapshot.ExceptionCauseSnapshot)matchedCause.get()).stackTraces).map(stackTrace -> String.valueOf(stackTrace.declaringClass) + "." + stackTrace.methodName).include(classAndMethod -> matchedClassAndMethodInStackTrace.equals(classAndMethod)).hasAny();
    }
}

