/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.utils.nameparser;

import io.datarouter.exception.utils.nameparser.ExceptionNameParser;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.lang.ReflectionTool;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ExceptionNameParserRegistry {
    private final Map<Set<String>, Class<? extends ExceptionNameParser>> parserClassByTypeName = new HashMap<Set<String>, Class<? extends ExceptionNameParser>>();

    protected abstract void registerNameParsers();

    protected ExceptionNameParserRegistry() {
        this.registerNameParsers();
    }

    protected void register(Class<? extends ExceptionNameParser> parserClass) {
        Set<String> parserTypeClassName = ((ExceptionNameParser)ReflectionTool.create(parserClass)).getMatchingTypeClassNames();
        if (this.parserClassByTypeName.containsKey(parserTypeClassName)) {
            throw new RuntimeException("type: " + parserTypeClassName + " was already registered");
        }
        this.parserClassByTypeName.put(parserTypeClassName, parserClass);
    }

    public List<Class<? extends ExceptionNameParser>> getNameParserClasses() {
        return Scanner.of(this.parserClassByTypeName.values()).list();
    }

    public static class NoOpExceptionNameParserRegistry
    extends ExceptionNameParserRegistry {
        @Override
        protected void registerNameParsers() {
        }
    }
}

