/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.utils.nameparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExceptionSnapshot {
    public final List<ExceptionCauseSnapshot> causes;

    public ExceptionSnapshot(Throwable exception) {
        ArrayList<ExceptionCauseSnapshot> causes = new ArrayList<ExceptionCauseSnapshot>();
        while (exception != null) {
            causes.add(new ExceptionCauseSnapshot(exception));
            exception = exception.getCause();
        }
        this.causes = causes;
    }

    public ExceptionSnapshot(List<ExceptionCauseSnapshot> causes) {
        this.causes = causes;
    }

    public Optional<ExceptionCauseSnapshot> getRootCause() {
        return this.causes.isEmpty() ? Optional.empty() : Optional.of(this.causes.get(this.causes.size() - 1));
    }

    public static class ExceptionCauseSnapshot {
        public final String typeName;
        public final String simpleTypeName;
        public final String detailMessage;
        public final List<StackTraceElementSnapshot> stackTraces;

        public ExceptionCauseSnapshot(String typeName, String simpleTypeName, String detailMessage, List<StackTraceElementSnapshot> stackTraces) {
            this.typeName = typeName;
            this.simpleTypeName = simpleTypeName;
            this.detailMessage = detailMessage;
            this.stackTraces = stackTraces;
        }

        public ExceptionCauseSnapshot(Class<? extends Throwable> typeClass, String detailMessage, List<StackTraceElementSnapshot> stackTraces) {
            this(typeClass.getName(), typeClass.getSimpleName(), detailMessage, stackTraces);
        }

        public ExceptionCauseSnapshot(Throwable exception) {
            this(exception.getClass(), exception.getMessage(), Arrays.stream(exception.getStackTrace()).map(StackTraceElementSnapshot::new).collect(Collectors.toList()));
        }
    }

    public static class StackTraceElementSnapshot {
        public final String declaringClass;
        public final String methodName;
        public final int lineNumber;

        public StackTraceElementSnapshot(StackTraceElement element) {
            this(element.getClassName(), element.getMethodName(), element.getLineNumber());
        }

        public StackTraceElementSnapshot(String declaringClass, String methodName, int lineNumber) {
            this.declaringClass = declaringClass;
            this.methodName = methodName;
            this.lineNumber = lineNumber;
        }
    }
}

