/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.web;

import com.google.gson.reflect.TypeToken;
import io.datarouter.exception.config.DatarouterExceptionFiles;
import io.datarouter.exception.config.DatarouterExceptionPaths;
import io.datarouter.exception.service.ExceptionGraphLink;
import io.datarouter.exception.storage.exceptionrecord.DatarouterExceptionRecordDao;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecord;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecordKey;
import io.datarouter.exception.storage.httprecord.DatarouterHttpRequestRecordDao;
import io.datarouter.exception.storage.httprecord.HttpRequestRecord;
import io.datarouter.gson.GsonTool;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.time.ZonedDateFormatterTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.user.session.CurrentUserSessionInfoService;
import io.datarouter.web.util.ExceptionService;
import io.datarouter.web.util.http.CookieTool;
import jakarta.inject.Inject;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletRequest;

public class ExceptionAnalysisHandler
extends BaseHandler {
    public static final String P_exceptionRecord = "exceptionRecord";
    @Inject
    private ExceptionService exceptionService;
    @Inject
    private DatarouterExceptionFiles files;
    @Inject
    private DatarouterExceptionPaths paths;
    @Inject
    private DatarouterExceptionRecordDao exceptionRecordDao;
    @Inject
    private DatarouterHttpRequestRecordDao httpRequestRecordDao;
    @Inject
    private ExceptionGraphLink exceptionGraphLink;
    @Inject
    private CurrentUserSessionInfoService currentUserSessionInfoService;

    @BaseHandler.Handler
    public Mav details(@Param(value="exceptionRecord") Optional<String> exceptionRecord) {
        Mav mav = new Mav(this.files.jsp.datarouter.exception.exceptionDetailsJsp);
        mav.put("detailsPath", (Object)this.paths.datarouter.exception.details.toSlashedString());
        if (exceptionRecord.isEmpty()) {
            return mav;
        }
        String exceptionRecordId = exceptionRecord.get();
        ExceptionRecord record = this.getExceptionRecord(exceptionRecordId = this.trimExceptionRecordId(exceptionRecordId));
        if (record == null) {
            return ExceptionAnalysisHandler.makeExceptionDoesNotExistMav(exceptionRecordId);
        }
        mav.put(P_exceptionRecord, (Object)this.toJspDto(record));
        mav.put("coloredStackTrace", (Object)this.exceptionService.getColorized(record.getStackTrace()));
        mav.put("shortStackTrace", (Object)this.exceptionService.getShortStackTrace(record.getStackTrace()));
        mav.put("serviceName", (Object)record.getServiceName());
        this.findHttpRequestRecord(record).map(this::toJspDto).ifPresent(dto -> {
            Object object = mav.put("httpRequestRecord", dto);
        });
        return mav;
    }

    private String trimExceptionRecordId(String exceptionRecordId) {
        if (StringTool.containsCaseInsensitive((String)exceptionRecordId, (String)"=")) {
            return StringTool.getStringAfterLastOccurrence((char)'=', (String)exceptionRecordId);
        }
        return exceptionRecordId;
    }

    private ExceptionRecord getExceptionRecord(String id) {
        return this.exceptionRecordDao.get(new ExceptionRecordKey(id));
    }

    private Optional<HttpRequestRecord> findHttpRequestRecord(ExceptionRecord exceptionRecord) {
        return this.httpRequestRecordDao.scanByExceptionRecordIdPrefix(((ExceptionRecordKey)exceptionRecord.getKey()).getId()).findFirst();
    }

    private static Mav makeExceptionDoesNotExistMav(String exceptionRecordId) {
        return new MessageMav("Exception record with id=" + exceptionRecordId + " does not exist");
    }

    private ExceptionRecordJspDto toJspDto(ExceptionRecord exceptionRecord) {
        return new ExceptionRecordJspDto(((ExceptionRecordKey)exceptionRecord.getKey()).getId(), exceptionRecord.getCreated(), exceptionRecord.getServerName(), exceptionRecord.getType(), exceptionRecord.getAppVersion(), exceptionRecord.getExceptionLocation(), exceptionRecord.getCallOrigin(), this.exceptionGraphLink.getMetricLink(exceptionRecord), this.exceptionGraphLink.getCallOriginLink(exceptionRecord), this.exceptionGraphLink.getExactMetricLink(exceptionRecord), this.currentUserSessionInfoService.getZoneId((ServletRequest)this.request));
    }

    private HttpRequestRecordJspDto toJspDto(HttpRequestRecord httpRequestRecord) {
        return new HttpRequestRecordJspDto(httpRequestRecord.getCreated(), httpRequestRecord.getReceivedAt(), httpRequestRecord.getDuration(), httpRequestRecord.getExceptionRecordId(), httpRequestRecord.getHttpMethod(), httpRequestRecord.getHttpParams(), httpRequestRecord.getProtocol(), httpRequestRecord.getHostname(), httpRequestRecord.getPort(), httpRequestRecord.getContextPath(), httpRequestRecord.getPath(), httpRequestRecord.getQueryString(), httpRequestRecord.getBinaryBody(), httpRequestRecord.getIp(), httpRequestRecord.getUserRoles(), httpRequestRecord.getUserToken(), httpRequestRecord.getTraceId(), httpRequestRecord.getParentId(), httpRequestRecord.getHeaders(), httpRequestRecord.getOtherHeaders());
    }

    public static class ExceptionRecordJspDto {
        private final String id;
        private final Date created;
        private final String serverName;
        private final String type;
        private final String appVersion;
        private final String exceptionLocation;
        private final String callOrigin;
        private final String metricLink;
        private final String callOriginLink;
        private final String exactMetricLink;
        private final ZoneId zoneId;

        public ExceptionRecordJspDto(String id, Date created, String serverName, String type, String appVersion, String exceptionLocation, String callOrigin, String metricLink, String callOriginLink, String exactMetricLink, ZoneId zoneId) {
            this.id = id;
            this.created = created;
            this.serverName = serverName;
            this.type = type;
            this.appVersion = appVersion;
            this.exceptionLocation = exceptionLocation;
            this.callOrigin = callOrigin;
            this.metricLink = metricLink;
            this.callOriginLink = callOriginLink;
            this.exactMetricLink = exactMetricLink;
            this.zoneId = zoneId;
        }

        public String getId() {
            return this.id;
        }

        public String getCreated() {
            return ZonedDateFormatterTool.formatDateWithZone((Date)this.created, (ZoneId)this.zoneId);
        }

        public String getServerName() {
            return this.serverName;
        }

        public String getType() {
            return this.type;
        }

        public String getAppVersion() {
            return this.appVersion;
        }

        public String getExceptionLocation() {
            return this.exceptionLocation;
        }

        public String getCallOrigin() {
            return this.callOrigin;
        }

        public String getMetricLink() {
            return this.metricLink;
        }

        public String getCallOriginLink() {
            return this.callOriginLink;
        }

        public String getExactMetricLink() {
            return this.exactMetricLink;
        }
    }

    public static class HttpRequestRecordJspDto {
        private final Date created;
        private final Date receivedAt;
        private final Long duration;
        private final String exceptionRecordId;
        private final String httpMethod;
        private final String httpParams;
        private final String protocol;
        private final String hostname;
        private final int port;
        private final String contextPath;
        private final String path;
        private final String queryString;
        private final byte[] binaryBody;
        private final String ip;
        private final String userRoles;
        private final String userToken;
        private final String traceId;
        private final String parentId;
        private final Map<String, String> headers;
        private final String otherHeaders;

        public HttpRequestRecordJspDto(Date created, Date receivedAt, Long duration, String exceptionRecordId, String httpMethod, String httpParams, String protocol, String hostname, int port, String contextPath, String path, String queryString, byte[] binaryBody, String ip, String userRoles, String userToken, String traceId, String parentId, Map<String, String> headers, String otherHeaders) {
            this.created = created;
            this.receivedAt = receivedAt;
            this.duration = duration;
            this.exceptionRecordId = exceptionRecordId;
            this.httpMethod = httpMethod;
            this.httpParams = httpParams;
            this.protocol = protocol;
            this.hostname = hostname;
            this.port = port;
            this.contextPath = contextPath;
            this.path = path;
            this.queryString = queryString;
            this.binaryBody = binaryBody;
            this.ip = ip;
            this.userRoles = userRoles;
            this.userToken = userToken;
            this.traceId = traceId;
            this.parentId = parentId;
            this.headers = headers;
            this.otherHeaders = otherHeaders;
        }

        public Map<String, String[]> getOtherHeadersMap() {
            return (Map)GsonTool.withUnregisteredEnums().fromJson(this.otherHeaders, new TypeToken<Map<String, String[]>>(){}.getType());
        }

        public Map<String, String[]> getHttpParamsMap() {
            return (Map)GsonTool.withUnregisteredEnums().fromJson(this.httpParams, new TypeToken<Map<String, String[]>>(){}.getType());
        }

        public Map<String, String> getCookiesMap() {
            return CookieTool.getMapFromString((String)this.headers.get("cookie"), (String)";", (String)"=");
        }

        public boolean isFromAjax() {
            return "XMLHttpRequest".equals(this.headers.get("x-requested-with"));
        }

        public String getUrl() {
            return String.valueOf(this.getProtocol()) + "://" + this.hostname + ":" + this.port + (this.contextPath == null ? "" : this.contextPath) + this.path + (this.queryString != null ? "?" + this.queryString : "");
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getStringBody() {
            if (this.binaryBody != null) {
                return new String(this.binaryBody);
            }
            return null;
        }

        public String getPrettyPrintedJsonBody() {
            try {
                return GsonTool.prettyPrint((String)this.getStringBody());
            }
            catch (Exception e) {
                return null;
            }
        }

        public Date getCreated() {
            return this.created;
        }

        public Date getReceivedAt() {
            return this.receivedAt;
        }

        public Long getDuration() {
            return this.duration;
        }

        public String getExceptionRecordId() {
            return this.exceptionRecordId;
        }

        public String getHttpMethod() {
            return this.httpMethod;
        }

        public String getHttpParams() {
            return this.httpParams;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public String getPath() {
            return this.path;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public byte[] getBinaryBody() {
            return this.binaryBody;
        }

        public String getIp() {
            return this.ip;
        }

        public String getUserRoles() {
            return this.userRoles;
        }

        public String getUserToken() {
            return this.userToken;
        }

        public String getTraceId() {
            return this.traceId;
        }

        public String getParentId() {
            return this.parentId;
        }
    }
}

