/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.config;

import io.datarouter.exception.config.DatarouterExceptionPaths;
import io.datarouter.exception.config.DatarouterExceptionRouteSet;
import io.datarouter.exception.config.DatarouterExceptionSettingRoot;
import io.datarouter.exception.config.DatarouterExceptionTriggerGroup;
import io.datarouter.exception.conveyors.ExceptionQueueConveyors;
import io.datarouter.exception.filter.GuiceExceptionHandlingFilter;
import io.datarouter.exception.service.DefaultExceptionHandlingConfig;
import io.datarouter.exception.service.DefaultExceptionRecorder;
import io.datarouter.exception.service.ExceptionGraphLink;
import io.datarouter.exception.service.ExceptionIssueLinkPrefixSupplier;
import io.datarouter.exception.service.ExceptionRecordAggregationDailyDigest;
import io.datarouter.exception.service.ExemptDailyDigestExceptions;
import io.datarouter.exception.storage.exceptionrecord.DatarouterExceptionRecordDao;
import io.datarouter.exception.storage.exceptionrecord.DatarouterExceptionRecordPublisherDao;
import io.datarouter.exception.storage.httprecord.DatarouterHttpRequestRecordDao;
import io.datarouter.exception.storage.httprecord.DatarouterHttpRequestRecordPublisherDao;
import io.datarouter.exception.storage.metadata.DatarouterExceptionRecordSummaryMetadataDao;
import io.datarouter.exception.storage.summary.DatarouterExceptionRecordSummaryDao;
import io.datarouter.instrumentation.exception.ExceptionRecordPublisher;
import io.datarouter.job.config.BaseJobPlugin;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaosModuleBuilder;
import io.datarouter.web.config.DatarouterWebPlugin;
import io.datarouter.web.dispatcher.FilterParams;
import io.datarouter.web.exception.ExceptionHandlingConfig;
import io.datarouter.web.exception.ExceptionRecorder;
import io.datarouter.web.navigation.DatarouterNavBarCategory;
import io.datarouter.web.navigation.NavBarCategory;
import java.util.ArrayList;
import java.util.List;

public class DatarouterExceptionPlugin
extends BaseJobPlugin {
    private final Class<? extends ExceptionGraphLink> exceptionGraphLinkClass;
    private final Class<? extends ExceptionRecorder> exceptionRecorderClass;
    private final Class<? extends ExceptionHandlingConfig> exceptionHandlingConfigClass;
    private final Class<? extends ExceptionRecordPublisher> exceptionRecordPublisher;
    private final Class<? extends ExemptDailyDigestExceptions> exemptDailyDigestExceptions;
    private final String issueLinkPrefix;

    private DatarouterExceptionPlugin(DatarouterExceptionDaoModule daosModuleBuilder, Class<? extends ExceptionGraphLink> exceptionGraphLinkClass, Class<? extends ExceptionRecorder> exceptionRecorderClass, Class<? extends ExceptionHandlingConfig> exceptionHandlingConfigClass, Class<? extends ExceptionRecordPublisher> exceptionRecordPublisher, Class<? extends ExemptDailyDigestExceptions> exemptDailyDigestExceptions, String issueLinkPrefix) {
        this.exceptionGraphLinkClass = exceptionGraphLinkClass;
        this.exceptionRecorderClass = exceptionRecorderClass;
        this.exceptionHandlingConfigClass = exceptionHandlingConfigClass;
        this.exceptionRecordPublisher = exceptionRecordPublisher;
        this.exemptDailyDigestExceptions = exemptDailyDigestExceptions;
        this.issueLinkPrefix = issueLinkPrefix;
        this.addFilterParamsOrdered(new FilterParams(false, "/*", GuiceExceptionHandlingFilter.class), DatarouterWebPlugin.REQUEST_CACHING_FILTER_PARAMS);
        this.addRouteSet(DatarouterExceptionRouteSet.class);
        this.addSettingRoot(DatarouterExceptionSettingRoot.class);
        this.addTriggerGroup(DatarouterExceptionTriggerGroup.class);
        this.setDaosModule(daosModuleBuilder);
        this.addDatarouterNavBarItem((NavBarCategory)DatarouterNavBarCategory.MONITORING, new DatarouterExceptionPaths().datarouter.exception.browse, "Exceptions");
        this.addDatarouterGithubDocLink("datarouter-exception");
        if (!exceptionRecordPublisher.isInstance(ExceptionRecordPublisher.NoOpExceptionRecordPublisher.class)) {
            this.addAppListener(ExceptionQueueConveyors.class);
        }
        this.addDailyDigest(ExceptionRecordAggregationDailyDigest.class);
    }

    public String getName() {
        return "DatarouterException";
    }

    protected void configure() {
        this.bindDefault(ExceptionGraphLink.class, this.exceptionGraphLinkClass);
        this.bindActual(ExceptionRecorder.class, this.exceptionRecorderClass);
        this.bindActual(ExceptionHandlingConfig.class, this.exceptionHandlingConfigClass);
        this.bind(ExceptionRecordPublisher.class).to(this.exceptionRecordPublisher);
        this.bind(ExemptDailyDigestExceptions.class).to(this.exemptDailyDigestExceptions);
        if (this.issueLinkPrefix == null) {
            this.bind(ExceptionIssueLinkPrefixSupplier.class).to(ExceptionIssueLinkPrefixSupplier.NoOpExceptionIssueLinkPrefixSupplier.class);
        } else {
            this.bindDefaultInstance(ExceptionIssueLinkPrefixSupplier.class, new ExceptionIssueLinkPrefixSupplier.ExceptionIssueLinkPrefix(this.issueLinkPrefix));
        }
    }

    public static class DatarouterExceptionDaoModule
    extends DaosModuleBuilder {
        private final List<ClientId> datarouterExceptionRecordClientId;
        private final List<ClientId> datarouterExceptionRecordSummaryClientId;
        private final List<ClientId> datarouterExceptionRecordSummaryMetadataClientId;
        private final List<ClientId> datarouterHttpRequestRecordClientId;
        private final ClientId datarouterExceptionRecordPublisherClientId;
        private final ClientId datarouterHttpRequestRecordPublisherClientId;

        public DatarouterExceptionDaoModule(ClientId defaultClientId, ClientId queueClientId) {
            this(List.of(defaultClientId), List.of(defaultClientId), List.of(defaultClientId), List.of(defaultClientId), queueClientId, queueClientId);
        }

        public DatarouterExceptionDaoModule(List<ClientId> datarouterExceptionRecordClientId, List<ClientId> datarouterExceptionRecordSummaryClientId, List<ClientId> datarouterExceptionRecordSummaryMetadataClientId, List<ClientId> datarouterHttpRequestRecordClientId, ClientId datarouterExceptionRecordPublisherClientId, ClientId datarouterHttpRequestRecordPublisherClientId) {
            this.datarouterExceptionRecordClientId = datarouterExceptionRecordClientId;
            this.datarouterExceptionRecordSummaryClientId = datarouterExceptionRecordSummaryClientId;
            this.datarouterExceptionRecordSummaryMetadataClientId = datarouterExceptionRecordSummaryMetadataClientId;
            this.datarouterHttpRequestRecordClientId = datarouterHttpRequestRecordClientId;
            this.datarouterExceptionRecordPublisherClientId = datarouterExceptionRecordPublisherClientId;
            this.datarouterHttpRequestRecordPublisherClientId = datarouterHttpRequestRecordPublisherClientId;
        }

        public List<Class<? extends Dao>> getDaoClasses() {
            ArrayList<Class<? extends Dao>> daos = new ArrayList<Class<? extends Dao>>();
            daos.add(DatarouterExceptionRecordDao.class);
            daos.add(DatarouterExceptionRecordSummaryDao.class);
            daos.add(DatarouterExceptionRecordSummaryMetadataDao.class);
            daos.add(DatarouterHttpRequestRecordDao.class);
            if (this.datarouterExceptionRecordPublisherClientId != null) {
                daos.add(DatarouterExceptionRecordPublisherDao.class);
            }
            if (this.datarouterHttpRequestRecordPublisherClientId != null) {
                daos.add(DatarouterHttpRequestRecordPublisherDao.class);
            }
            return daos;
        }

        public void configure() {
            this.bind(DatarouterHttpRequestRecordDao.DatarouterHttpRequestRecordDaoParams.class).toInstance((Object)new DatarouterHttpRequestRecordDao.DatarouterHttpRequestRecordDaoParams(this.datarouterHttpRequestRecordClientId));
            this.bind(DatarouterExceptionRecordDao.DatarouterExceptionRecordDaoParams.class).toInstance((Object)new DatarouterExceptionRecordDao.DatarouterExceptionRecordDaoParams(this.datarouterExceptionRecordClientId));
            this.bind(DatarouterExceptionRecordSummaryDao.DatarouterExceptionRecordSummaryDaoParams.class).toInstance((Object)new DatarouterExceptionRecordSummaryDao.DatarouterExceptionRecordSummaryDaoParams(this.datarouterExceptionRecordSummaryClientId));
            this.bind(DatarouterExceptionRecordSummaryMetadataDao.DatarouterExceptionRecordSummaryMetadataDaoParams.class).toInstance((Object)new DatarouterExceptionRecordSummaryMetadataDao.DatarouterExceptionRecordSummaryMetadataDaoParams(this.datarouterExceptionRecordSummaryMetadataClientId));
            if (this.datarouterExceptionRecordPublisherClientId != null) {
                this.bind(DatarouterExceptionRecordPublisherDao.DatarouterExceptionPublisherRouterParams.class).toInstance((Object)new DatarouterExceptionRecordPublisherDao.DatarouterExceptionPublisherRouterParams(this.datarouterExceptionRecordPublisherClientId));
            }
            if (this.datarouterHttpRequestRecordPublisherClientId != null) {
                this.bind(DatarouterHttpRequestRecordPublisherDao.DatarouterHttpRequestRecordPublisherDaoParams.class).toInstance((Object)new DatarouterHttpRequestRecordPublisherDao.DatarouterHttpRequestRecordPublisherDaoParams(this.datarouterHttpRequestRecordPublisherClientId));
            }
        }
    }

    public static class DatarouterExceptionPluginBuilder {
        private final ClientId defaultClientId;
        private ClientId defaultQueueClientId;
        private Class<? extends ExceptionGraphLink> exceptionGraphLinkClass = ExceptionGraphLink.NoOpExceptionGraphLink.class;
        private Class<? extends ExceptionRecorder> exceptionRecorderClass = DefaultExceptionRecorder.class;
        private Class<? extends ExceptionHandlingConfig> exceptionHandlingConfigClass = DefaultExceptionHandlingConfig.class;
        private Class<? extends ExceptionRecordPublisher> exceptionRecordPublisher = ExceptionRecordPublisher.NoOpExceptionRecordPublisher.class;
        private Class<? extends ExemptDailyDigestExceptions> exemptDailyDigestExceptions = ExemptDailyDigestExceptions.NoOpExemptDailyDigestExceptions.class;
        private String issueLinkPrefix;

        public DatarouterExceptionPluginBuilder(ClientId defaultClientId) {
            this.defaultClientId = defaultClientId;
        }

        public DatarouterExceptionPluginBuilder setExceptionGraphLinkClass(Class<? extends ExceptionGraphLink> exceptionGraphLinkClass) {
            this.exceptionGraphLinkClass = exceptionGraphLinkClass;
            return this;
        }

        public DatarouterExceptionPluginBuilder setExceptionRecorderClass(Class<? extends ExceptionRecorder> exceptionRecorderClass) {
            this.exceptionRecorderClass = exceptionRecorderClass;
            return this;
        }

        public DatarouterExceptionPluginBuilder setExceptionHandlingClass(Class<? extends ExceptionHandlingConfig> exceptionHandlingConfigClass) {
            this.exceptionHandlingConfigClass = exceptionHandlingConfigClass;
            return this;
        }

        public DatarouterExceptionPluginBuilder setExemptDailyDigestExceptions(Class<? extends ExemptDailyDigestExceptions> exemptDailyDigestExceptions) {
            this.exemptDailyDigestExceptions = exemptDailyDigestExceptions;
            return this;
        }

        public DatarouterExceptionPluginBuilder enablePublishing(Class<? extends ExceptionRecordPublisher> exceptionRecordPublisher, ClientId defaultQueueClientId) {
            this.exceptionRecordPublisher = exceptionRecordPublisher;
            this.defaultQueueClientId = defaultQueueClientId;
            return this;
        }

        public DatarouterExceptionPluginBuilder withIssueLinkPrefix(String issueLinkPrefix) {
            this.issueLinkPrefix = issueLinkPrefix;
            return this;
        }

        public DatarouterExceptionPlugin build() {
            return new DatarouterExceptionPlugin(new DatarouterExceptionDaoModule(this.defaultClientId, this.defaultQueueClientId), this.exceptionGraphLinkClass, this.exceptionRecorderClass, this.exceptionHandlingConfigClass, this.exceptionRecordPublisher, this.exemptDailyDigestExceptions, this.issueLinkPrefix);
        }
    }
}

