/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.conveyors;

import io.datarouter.conveyor.queue.BaseGroupQueueConsumerConveyor;
import io.datarouter.conveyor.queue.GroupQueueConsumer;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecord;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecordKey;
import io.datarouter.instrumentation.exception.ExceptionRecordBatchDto;
import io.datarouter.instrumentation.exception.ExceptionRecordPublisher;
import io.datarouter.instrumentation.response.PublishingResponseDto;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.exception.ExceptionRecorder;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExceptionRecordQueueConveyor
extends BaseGroupQueueConsumerConveyor<ExceptionRecordKey, ExceptionRecord> {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionRecordQueueConveyor.class);
    private final ExceptionRecordPublisher publisher;

    @Inject
    public ExceptionRecordQueueConveyor(String name, Supplier<Boolean> shouldRun, GroupQueueConsumer<ExceptionRecordKey, ExceptionRecord> consumer, ExceptionRecordPublisher publisher, Supplier<Boolean> compactExceptionLogging, ExceptionRecorder exceptionRecorder) {
        super(name, shouldRun, consumer, compactExceptionLogging, Duration.ofSeconds(30L), exceptionRecorder);
        this.publisher = publisher;
    }

    protected void processDatabeans(List<ExceptionRecord> records) {
        ExceptionRecordBatchDto batch = (ExceptionRecordBatchDto)Scanner.of(records).map(ExceptionRecord::toDto).listTo(ExceptionRecordBatchDto::new);
        PublishingResponseDto response = this.publisher.addExceptionRecord(batch);
        if (response.message.equals("discard")) {
            logger.info("The message was accepted but discarded.");
        }
        if (response.success == null || !response.success.booleanValue()) {
            throw new RuntimeException("failed to publish response=" + response.message);
        }
    }
}

