/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.filter;

import io.datarouter.exception.storage.exceptionrecord.BaseExceptionRecordKey;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecordKey;
import io.datarouter.inject.DatarouterInjector;
import io.datarouter.instrumentation.count.Counters;
import io.datarouter.instrumentation.exception.ExceptionRecordDto;
import io.datarouter.util.tuple.Pair;
import io.datarouter.web.app.WebappName;
import io.datarouter.web.config.DatarouterWebSettingRoot;
import io.datarouter.web.exception.ExceptionRecorder;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.encoder.DefaultEncoder;
import io.datarouter.web.handler.encoder.HandlerEncoder;
import io.datarouter.web.inject.InjectorRetriever;
import io.datarouter.web.util.RequestAttributeKey;
import io.datarouter.web.util.RequestAttributeTool;
import io.datarouter.web.util.http.RequestTool;
import io.datarouter.web.util.http.exception.HttpExceptionTool;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExceptionHandlingFilter
implements Filter,
InjectorRetriever {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionHandlingFilter.class);
    private static final Set<Integer> statusToLog = Set.of(Integer.valueOf(404), Integer.valueOf(403), Integer.valueOf(555));
    private DatarouterInjector injector;
    private WebappName webappName;
    private ExceptionRecorder exceptionRecorder;
    private DatarouterWebSettingRoot webSettings;

    public void init(FilterConfig filterConfig) {
        this.injector = this.getInjector(filterConfig.getServletContext());
        this.webappName = (WebappName)this.injector.getInstance(WebappName.class);
        this.exceptionRecorder = (ExceptionRecorder)this.injector.getInstance(ExceptionRecorder.class);
        this.webSettings = (DatarouterWebSettingRoot)this.injector.getInstance(DatarouterWebSettingRoot.class);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain fc) throws IOException {
        HttpServletResponse response = (HttpServletResponse)res;
        HttpServletRequest request = (HttpServletRequest)req;
        RequestAttributeTool.set((ServletRequest)request, (RequestAttributeKey)BaseHandler.REQUEST_RECEIVED_AT, (Object)new Date());
        try {
            fc.doFilter(req, res);
        }
        catch (Throwable e) {
            Optional<String> exceptionId = this.tryRecordExceptionAndRequestNotification(request, e).map(BaseExceptionRecordKey::getId);
            logger.error("ExceptionHandlingFilter caught an exception exceptionId={}", (Object)exceptionId.orElse(""), (Object)e);
            exceptionId.ifPresent(id -> response.setHeader("x-eid", id));
            this.writeExceptionToResponseWriter(response, e, request, exceptionId);
        }
        Counters.inc((String)(this.webappName + " response " + response.getStatus()));
        if (statusToLog.contains(response.getStatus())) {
            logger.warn("{} on {} ip={} userAgent={}", new Object[]{response.getStatus(), RequestTool.getRequestUriWithQueryString((HttpServletRequest)request), RequestTool.getIpAddress((HttpServletRequest)request), RequestTool.getUserAgent((HttpServletRequest)request)});
        }
    }

    private static void dumpAllStackTraces() throws IOException {
        long timeMillis = System.currentTimeMillis();
        Throwable throwable = null;
        Object var3_3 = null;
        try (BufferedWriter out = new BufferedWriter(new FileWriter("/tmp/StackTrace" + timeMillis + ".log"));){
            Map<Thread, StackTraceElement[]> liveThreads = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> thread : liveThreads.entrySet()) {
                out.append("Thread " + thread.getKey().getName() + "\n");
                StackTraceElement[] stackTraceElementArray = thread.getValue();
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement element = stackTraceElementArray[n2];
                    out.append("\tat " + element + "\n");
                    ++n2;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Optional<ExceptionRecordKey> tryRecordExceptionAndRequestNotification(HttpServletRequest request, Throwable exception) {
        try {
            String methodName = null;
            Pair<String, Integer> pair = ExceptionHandlingFilter.searchJspName(exception);
            String location = (String)pair.getLeft();
            Integer lineNumber = (Integer)pair.getRight();
            if (location == null) {
                Optional<StackTraceElement> element = this.searchClassName(exception);
                if (element.isPresent()) {
                    location = element.get().getClassName();
                    methodName = element.get().getMethodName();
                    lineNumber = element.get().getLineNumber();
                } else {
                    location = "unknown location";
                }
            }
            Optional handlerClass = RequestAttributeTool.get((ServletRequest)request, (RequestAttributeKey)BaseHandler.HANDLER_CLASS);
            Optional handlerMethod = RequestAttributeTool.get((ServletRequest)request, (RequestAttributeKey)BaseHandler.HANDLER_METHOD);
            String callOrigin = handlerClass.isPresent() && handlerMethod.isPresent() ? String.valueOf(((Class)handlerClass.get()).getName()) + "." + ((Method)handlerMethod.get()).getName() : null;
            ExceptionRecordDto exceptionRecord = this.exceptionRecorder.recordExceptionAndHttpRequest(exception, location, methodName, lineNumber, request, callOrigin);
            return Optional.of(new ExceptionRecordKey(exceptionRecord.id));
        }
        catch (Exception e) {
            logger.error("Exception while logging", (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<StackTraceElement> searchClassName(Throwable exception) {
        Throwable cause = exception;
        Set highlights = (Set)this.webSettings.stackTraceHighlights.get();
        do {
            StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                for (String highlight : highlights) {
                    if (!element.getClassName().contains(highlight)) continue;
                    return Optional.of(element);
                }
                ++n2;
            }
        } while ((cause = cause.getCause()) != null);
        return Optional.empty();
    }

    private static Pair<String, Integer> searchJspName(Throwable exception) {
        Integer lineNumber = null;
        Throwable cause = exception;
        do {
            String place;
            String key = "An exception occurred processing JSP page ";
            if (cause.getMessage() == null) {
                cause = cause.getCause();
                continue;
            }
            int indexOfBegin = cause.getMessage().indexOf(key);
            if (indexOfBegin > -1) {
                String key2 = " at line ";
                int index = cause.getMessage().indexOf(key2);
                int endLine = cause.getMessage().indexOf("\n");
                place = cause.getMessage().substring(indexOfBegin + key.length(), index);
                try {
                    lineNumber = Integer.parseInt(cause.getMessage().substring(index + key2.length(), endLine));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return new Pair((Object)place, lineNumber);
            }
            String keyInTheJspFile = " in the jsp file: ";
            indexOfBegin = cause.getMessage().indexOf(keyInTheJspFile);
            if (indexOfBegin > -1) {
                String key2 = " at line: ";
                int index = cause.getMessage().indexOf(key2);
                int endLine = cause.getMessage().indexOf(10, indexOfBegin);
                place = cause.getMessage().substring(indexOfBegin + keyInTheJspFile.length(), endLine);
                try {
                    lineNumber = Integer.parseInt(cause.getMessage().substring(index + key2.length(), indexOfBegin));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return new Pair((Object)place, (Object)lineNumber);
            }
            place = ExceptionHandlingFilter.getJspName(cause.getMessage());
            if (place != null) {
                return new Pair((Object)place, lineNumber);
            }
            StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                place = ExceptionHandlingFilter.getJspName(element.getClassName());
                if (place != null) {
                    return new Pair((Object)place, (Object)lineNumber);
                }
                ++n2;
            }
            cause = cause.getCause();
        } while (cause != null);
        return new Pair(null, null);
    }

    private static String getJspName(String string) {
        if (string == null) {
            return null;
        }
        String key = "WEB_002dINF";
        int index = string.indexOf(key);
        if (index > -1) {
            String jspName = string.substring(index);
            jspName = jspName.replaceAll("\\.", "/");
            jspName = jspName.replaceAll("_002d", "-");
            jspName = jspName.replaceAll("_", ".");
            return "/" + jspName;
        }
        return null;
    }

    private void writeExceptionToResponseWriter(HttpServletResponse response, Throwable exception, HttpServletRequest request, Optional<String> exceptionId) {
        try {
            HandlerEncoder encoder = RequestAttributeTool.get((ServletRequest)request, (RequestAttributeKey)BaseHandler.HANDLER_ENCODER_ATTRIBUTE).orElseGet(() -> (HandlerEncoder)this.injector.getInstance(DefaultEncoder.class));
            int httpStatusCode = HttpExceptionTool.getHttpStatusCodeForException((HttpServletResponse)response, (Throwable)exception);
            response.setStatus(httpStatusCode);
            encoder.sendExceptionResponse(request, response, exception, exceptionId);
        }
        catch (Exception e) {
            logger.error("Exception while writing error http response", (Throwable)e);
        }
    }
}

