/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.service;

import io.datarouter.exception.config.DatarouterExceptionSettingRoot;
import io.datarouter.exception.service.ExceptionRecordService;
import io.datarouter.exception.storage.metadata.DatarouterExceptionRecordSummaryMetadataDao;
import io.datarouter.exception.storage.metadata.ExceptionRecordSummaryMetadata;
import io.datarouter.exception.storage.metadata.ExceptionRecordSummaryMetadataKey;
import io.datarouter.instrumentation.exception.ExceptionRecordDto;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.web.exception.ExceptionHandlingConfig;
import io.datarouter.web.monitoring.exception.ExceptionDto;
import io.datarouter.web.user.session.DatarouterSession;
import io.datarouter.web.user.session.DatarouterSessionManager;
import io.datarouter.web.user.session.service.RoleManager;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class DefaultExceptionHandlingConfig
implements ExceptionHandlingConfig {
    @Inject
    private DatarouterExceptionSettingRoot settings;
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private DatarouterExceptionRecordSummaryMetadataDao exceptionSummaryMetadataDao;
    @Inject
    private RoleManager roleManager;
    @Inject
    private ExceptionRecordService exceptionRecordService;

    public boolean shouldDisplayStackTrace(HttpServletRequest request, Throwable exception) {
        return (Boolean)this.settings.forceHideStackTrace.get() == false && this.isInternalUser(request);
    }

    protected boolean isInternalUser(HttpServletRequest request) {
        if (!this.isDevServer()) {
            if (!DatarouterSessionManager.getFromRequest((ServletRequest)request).map(DatarouterSession::getRoles).map(arg_0 -> ((RoleManager)this.roleManager).isAdmin(arg_0)).orElse(false).booleanValue()) {
                return false;
            }
        }
        return true;
    }

    public boolean shouldReportError(ExceptionRecordDto exceptionRecord) {
        if (!((Boolean)this.settings.shouldReport.get()).booleanValue()) {
            return false;
        }
        ExceptionRecordSummaryMetadataKey metadataKey = new ExceptionRecordSummaryMetadataKey(exceptionRecord.type, exceptionRecord.exceptionLocation);
        ExceptionRecordSummaryMetadata recordMetadata = this.exceptionSummaryMetadataDao.get(metadataKey);
        return recordMetadata == null || recordMetadata.getMuted() == null || recordMetadata.getMuted() == false;
    }

    public boolean shouldReportError(ExceptionDto dto) {
        return (Boolean)this.settings.shouldReport.get() != false;
    }

    public String getHtmlErrorMessage(Exception exception) {
        return "Error";
    }

    public boolean isDevServer() {
        return this.datarouterProperties.getServerType().getPersistentString().equals(ServerType.DEV.getPersistentString());
    }

    public String buildExceptionLinkForCurrentServer(String exceptionRecordId) {
        return this.exceptionRecordService.buildExceptionLinkForCurrentServer(exceptionRecordId);
    }
}

