/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.service;

import io.datarouter.exception.storage.summary.ExceptionRecordSummary;
import io.datarouter.exception.storage.summary.ExceptionRecordSummaryKey;
import java.util.List;

public interface ExemptDailyDigestExceptions {
    public List<ExemptDailyDigestException> getExemptExceptionAndLocations();

    default public boolean isExempt(ExceptionRecordSummary exception) {
        return this.getExemptExceptionAndLocations().stream().anyMatch(dto -> ((ExceptionRecordSummaryKey)exception.getKey()).getType().equals(dto.type.getCanonicalName()) && ((ExceptionRecordSummaryKey)exception.getKey()).getExceptionLocation().equals(dto.location.getCanonicalName()));
    }

    public static class ExemptDailyDigestException {
        private final Class<?> location;
        private final Class<? extends Exception> type;

        public ExemptDailyDigestException(Class<?> location, Class<? extends Exception> exception) {
            this.location = location;
            this.type = exception;
        }
    }

    public static class NoOpExemptDailyDigestExceptions
    implements ExemptDailyDigestExceptions {
        @Override
        public List<ExemptDailyDigestException> getExemptExceptionAndLocations() {
            return List.of();
        }
    }
}

