/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.storage.httprecord;

import io.datarouter.exception.storage.httprecord.HttpRequestRecord;
import io.datarouter.exception.storage.httprecord.HttpRequestRecordKey;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.key.unique.UniqueKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseRedundantDaoParams;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.IndexedSortedMapStorage;
import io.datarouter.storage.util.DatabeanVacuum;
import io.datarouter.virtualnode.redundant.RedundantIndexedSortedMapStorageNode;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterHttpRequestRecordDao
extends BaseDao {
    private final IndexedSortedMapStorage.IndexedSortedMapStorageNode<HttpRequestRecordKey, HttpRequestRecord, HttpRequestRecord.HttpRequestRecordFielder> node;

    @Inject
    public DatarouterHttpRequestRecordDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterHttpRequestRecordDaoParams params) {
        super(datarouter);
        this.node = (IndexedSortedMapStorage.IndexedSortedMapStorageNode)Scanner.of((Iterable)params.clientIds).map(clientId -> {
            IndexedSortedMapStorage.IndexedSortedMapStorageNode node = (IndexedSortedMapStorage.IndexedSortedMapStorageNode)nodeFactory.create(clientId, HttpRequestRecord::new, HttpRequestRecord.HttpRequestRecordFielder::new).withIsSystemTable(true).build();
            return node;
        }).listTo(RedundantIndexedSortedMapStorageNode::new);
        datarouter.register(this.node);
    }

    public HttpRequestRecord lookupUnique(HttpRequestRecord.HttpRequestRecordByExceptionRecord key) {
        return (HttpRequestRecord)this.node.lookupUnique((UniqueKey)key);
    }

    public void put(HttpRequestRecord databean) {
        this.node.put((Databean)databean);
    }

    public void putMulti(Collection<HttpRequestRecord> databeans) {
        this.node.putMulti(databeans);
    }

    public HttpRequestRecord get(HttpRequestRecordKey key) {
        return (HttpRequestRecord)this.node.get((PrimaryKey)key);
    }

    public List<HttpRequestRecord> getMulti(Collection<HttpRequestRecordKey> keys) {
        return this.node.getMulti(keys);
    }

    public void deleteAll() {
        this.node.deleteAll();
    }

    public void delete(HttpRequestRecordKey key) {
        this.node.delete((PrimaryKey)key);
    }

    public void deleteMulti(Collection<HttpRequestRecordKey> keys) {
        this.node.deleteMulti(keys);
    }

    public DatabeanVacuum<HttpRequestRecordKey, HttpRequestRecord> makeVacuum() {
        Duration lifespan = Duration.ofDays(14L);
        return new DatabeanVacuum.DatabeanVacuumBuilder(this.node.scan(), databean -> System.currentTimeMillis() - databean.getCreated().getTime() > lifespan.toMillis(), arg_0 -> this.node.deleteMulti(arg_0)).build();
    }

    public static class DatarouterHttpRequestRecordDaoParams
    extends BaseRedundantDaoParams {
        public DatarouterHttpRequestRecordDaoParams(List<ClientId> clientIds) {
            super(clientIds);
        }
    }
}

