/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.storage.summary;

import io.datarouter.exception.storage.exceptionrecord.BaseExceptionRecord;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.comparable.LongField;
import io.datarouter.model.field.imp.comparable.LongFieldKey;
import io.datarouter.model.key.primary.RegularPrimaryKey;
import io.datarouter.model.key.primary.base.BaseRegularPrimaryKey;
import java.util.List;

public abstract class BaseExceptionRecordSummaryKey<PK extends RegularPrimaryKey<PK>>
extends BaseRegularPrimaryKey<PK> {
    private Long reversePeriodStart;
    private String type;
    private String exceptionLocation;

    public BaseExceptionRecordSummaryKey() {
    }

    public BaseExceptionRecordSummaryKey(long periodStart, String type, String exceptionLocation) {
        this.reversePeriodStart = Long.MAX_VALUE - periodStart;
        this.type = type;
        this.exceptionLocation = exceptionLocation;
    }

    public List<Field<?>> getFields() {
        return List.of(new LongField(FieldKeys.reversePeriodStart, this.reversePeriodStart), new StringField(BaseExceptionRecord.FieldKeys.type, this.type), new StringField(BaseExceptionRecord.FieldKeys.exceptionLocation, this.exceptionLocation));
    }

    public long getPeriodStart() {
        return Long.MAX_VALUE - this.reversePeriodStart;
    }

    public long getReversePeriodStart() {
        return this.reversePeriodStart;
    }

    public String getType() {
        return this.type;
    }

    public String getExceptionLocation() {
        return this.exceptionLocation;
    }

    public static class FieldKeys {
        public static final LongFieldKey reversePeriodStart = new LongFieldKey("reversePeriodStart");
    }
}

