/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.web;

import com.google.gson.reflect.TypeToken;
import io.datarouter.exception.config.DatarouterExceptionFiles;
import io.datarouter.exception.config.DatarouterExceptionPaths;
import io.datarouter.exception.service.ExceptionGraphLink;
import io.datarouter.exception.service.ExceptionIssueLinkPrefixSupplier;
import io.datarouter.exception.storage.exceptionrecord.DatarouterExceptionRecordDao;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecord;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecordKey;
import io.datarouter.exception.storage.httprecord.DatarouterHttpRequestRecordDao;
import io.datarouter.exception.storage.httprecord.HttpRequestRecord;
import io.datarouter.exception.storage.metadata.DatarouterExceptionRecordSummaryMetadataDao;
import io.datarouter.exception.storage.metadata.ExceptionRecordSummaryMetadata;
import io.datarouter.exception.storage.metadata.ExceptionRecordSummaryMetadataKey;
import io.datarouter.exception.storage.summary.BaseExceptionRecordSummary;
import io.datarouter.exception.storage.summary.DatarouterExceptionRecordSummaryDao;
import io.datarouter.exception.storage.summary.ExceptionRecordSummary;
import io.datarouter.exception.storage.summary.ExceptionRecordSummaryKey;
import io.datarouter.model.databean.Databean;
import io.datarouter.util.BooleanTool;
import io.datarouter.util.DateTool;
import io.datarouter.util.serialization.GsonTool;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.exception.ExceptionCounters;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.GlobalRedirectMav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.handler.types.optional.OptionalBoolean;
import io.datarouter.web.handler.types.optional.OptionalString;
import io.datarouter.web.user.session.CurrentUserSessionInfoService;
import io.datarouter.web.util.ExceptionService;
import io.datarouter.web.util.http.CookieTool;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletRequest;

public class ExceptionAnalysisHandler
extends BaseHandler {
    public static final String P_exceptionRecord = "exceptionRecord";
    @Inject
    private ExceptionService exceptionService;
    @Inject
    private DatarouterExceptionFiles files;
    @Inject
    private DatarouterExceptionPaths paths;
    @Inject
    private DatarouterExceptionRecordDao exceptionRecordDao;
    @Inject
    private DatarouterHttpRequestRecordDao httpRequestRecordDao;
    @Inject
    private DatarouterExceptionRecordSummaryDao exceptionRecordSummaryDao;
    @Inject
    private DatarouterExceptionRecordSummaryMetadataDao exceptionSummaryMetadataDao;
    @Inject
    private ExceptionGraphLink exceptionGraphLink;
    @Inject
    private ExceptionIssueLinkPrefixSupplier issueLinkPrefixSupplier;
    @Inject
    private CurrentUserSessionInfoService currentUserSessionInfoService;

    @BaseHandler.Handler
    public Mav browse() {
        Mav mav = new Mav(this.files.jsp.datarouter.exception.browseExceptionsJsp);
        Long lastPeriodStart = null;
        TreeSet<ExceptionRecordSummary> summaries = new TreeSet<ExceptionRecordSummary>(Comparator.comparing(BaseExceptionRecordSummary::getNumExceptions, Comparator.reverseOrder()));
        HashSet<ExceptionRecordSummaryMetadataKey> metadataKeys = new HashSet<ExceptionRecordSummaryMetadataKey>();
        for (ExceptionRecordSummary summary : this.exceptionRecordSummaryDao.scan().iterable()) {
            if (lastPeriodStart == null) {
                lastPeriodStart = ((ExceptionRecordSummaryKey)summary.getKey()).getPeriodStart();
            } else if (lastPeriodStart.longValue() != ((ExceptionRecordSummaryKey)summary.getKey()).getPeriodStart()) break;
            summaries.add(summary);
            metadataKeys.add(((ExceptionRecordSummaryKey)summary.getKey()).getExceptionRecordSummaryMetadataKey());
        }
        mav.put("exceptionRecordSummaries", summaries);
        Map summaryMetadatas = this.exceptionSummaryMetadataDao.getMulti(metadataKeys).stream().collect(Collectors.toMap(Databean::getKey, Function.identity()));
        mav.put("summaryMetadatas", summaryMetadatas);
        if (lastPeriodStart != null) {
            mav.put("lastPeriodStart", (Object)ZonedDateTime.ofInstant(Instant.ofEpochMilli(lastPeriodStart), ZoneId.systemDefault()).format(DateTimeFormatter.RFC_1123_DATE_TIME));
        }
        mav.put("detailsPath", (Object)this.paths.datarouter.exception.details.toSlashedString());
        mav.put("issueLinkPrefix", (Object)((String)this.issueLinkPrefixSupplier.get()));
        return mav;
    }

    protected Mav initDetailsMav() {
        return new Mav(this.files.jsp.datarouter.exception.exceptionDetailsJsp);
    }

    @BaseHandler.Handler
    public Mav details(@Param(value="exceptionRecord") OptionalString exceptionRecord) {
        Mav mav = this.initDetailsMav();
        mav.put("detailsPath", (Object)this.paths.datarouter.exception.details.toSlashedString());
        if (exceptionRecord.isEmpty()) {
            return mav;
        }
        String exceptionRecordId = (String)exceptionRecord.get();
        ExceptionRecord record = this.getExceptionRecord(exceptionRecordId = this.trimExceptionRecordId(exceptionRecordId));
        if (record == null) {
            return new MessageMav("Exception record with id=" + exceptionRecordId + " does not exist");
        }
        HttpRequestRecordJspDto httpRequestRecordJspDto = null;
        mav.put(P_exceptionRecord, (Object)this.toJspDto(record));
        mav.put("coloredStackTrace", (Object)this.exceptionService.getColorized(record.getStackTrace()));
        mav.put("shortStackTrace", (Object)this.exceptionService.getShortStackTrace(record.getStackTrace()));
        mav.put("serviceName", (Object)record.getServiceName());
        HttpRequestRecord httpRequestRecord = this.getHttpRequestRecord(record);
        if (httpRequestRecord != null) {
            httpRequestRecordJspDto = this.toJspDto(httpRequestRecord);
            mav.put("httpRequestRecord", (Object)httpRequestRecordJspDto);
        }
        mav.put("browsePath", (Object)this.paths.datarouter.exception.browse.toSlashedString());
        return mav;
    }

    @BaseHandler.Handler
    public String mute(String type, String exceptionLocation, Boolean muted) {
        return this.createOrUpdateMetadata(type, exceptionLocation, metadata -> metadata.setMuted(muted));
    }

    @BaseHandler.Handler
    public String saveIssue(String type, String exceptionLocation, String issue) {
        String cleanedIssue = Optional.of(issue).map(String::trim).filter(StringTool::notEmpty).orElse(null);
        return this.createOrUpdateMetadata(type, exceptionLocation, metadata -> metadata.setIssue(cleanedIssue));
    }

    @BaseHandler.Handler
    public Mav recordIssueAndRedirect(String type, String exceptionRecordId, String issue, OptionalBoolean muted) {
        if (StringTool.isNullOrEmptyOrWhitespace((String)issue)) {
            throw new IllegalArgumentException("Issue ID cannot be empty");
        }
        String trimmedIssue = issue.trim();
        String exceptionLocation = this.getExceptionRecord(exceptionRecordId).getExceptionLocation();
        this.createOrUpdateMetadata(type, exceptionLocation, metadata -> {
            if (!trimmedIssue.equals(metadata.getIssue())) {
                metadata.setIssue(trimmedIssue);
                ExceptionCounters.inc((String)"linked issue");
                ExceptionCounters.inc((String)("linked issue " + StringTool.getStringBeforeFirstOccurrence((char)'-', (String)trimmedIssue)));
            }
            if (BooleanTool.isFalseOrNull((Boolean)metadata.getMuted())) {
                muted.filter(BooleanTool::isTrue).ifPresent($ -> {
                    metadata.setMuted(true);
                    ExceptionCounters.inc((String)"muted");
                });
            }
        });
        return new GlobalRedirectMav(this.request.getRequestURI());
    }

    private String createOrUpdateMetadata(String type, String exceptionLocation, Consumer<ExceptionRecordSummaryMetadata> action) {
        ExceptionRecordSummaryMetadataKey key = this.getExceptionRecordSummaryMetadataKey(type, exceptionLocation);
        ExceptionRecordSummaryMetadata metadata = this.exceptionSummaryMetadataDao.get(key);
        if (metadata == null) {
            metadata = this.getExceptionRecordSummaryMetadata(key);
        }
        action.accept(metadata);
        this.exceptionSummaryMetadataDao.put(metadata);
        return "success";
    }

    private String trimExceptionRecordId(String exceptionRecordId) {
        if (StringTool.containsCaseInsensitive((String)exceptionRecordId, (String)"=")) {
            return StringTool.getStringAfterLastOccurrence((char)'=', (String)exceptionRecordId);
        }
        return exceptionRecordId;
    }

    protected ExceptionRecord getExceptionRecord(String id) {
        return this.exceptionRecordDao.get(new ExceptionRecordKey(id));
    }

    protected HttpRequestRecord getHttpRequestRecord(ExceptionRecord exceptionRecord) {
        HttpRequestRecord.HttpRequestRecordByExceptionRecord key = new HttpRequestRecord.HttpRequestRecordByExceptionRecord(exceptionRecord);
        return this.httpRequestRecordDao.lookupUnique(key);
    }

    protected ExceptionRecordSummaryMetadataKey getExceptionRecordSummaryMetadataKey(String type, String exceptionLocation) {
        return new ExceptionRecordSummaryMetadataKey(type, exceptionLocation);
    }

    protected ExceptionRecordSummaryMetadata getExceptionRecordSummaryMetadata(ExceptionRecordSummaryMetadataKey key) {
        return new ExceptionRecordSummaryMetadata(key);
    }

    private ExceptionRecordJspDto toJspDto(ExceptionRecord exceptionRecord) {
        return new ExceptionRecordJspDto(((ExceptionRecordKey)exceptionRecord.getKey()).getId(), exceptionRecord.getCreated(), exceptionRecord.getServerName(), exceptionRecord.getType(), exceptionRecord.getAppVersion(), exceptionRecord.getExceptionLocation(), exceptionRecord.getCallOrigin(), this.exceptionGraphLink.getMetricLink(exceptionRecord), this.exceptionGraphLink.getCallOriginLink(exceptionRecord), this.exceptionGraphLink.getExactMetricLink(exceptionRecord), this.currentUserSessionInfoService.getZoneId((ServletRequest)this.request));
    }

    private HttpRequestRecordJspDto toJspDto(HttpRequestRecord httpRequestRecord) {
        return new HttpRequestRecordJspDto(httpRequestRecord.getCreated(), httpRequestRecord.getReceivedAt(), httpRequestRecord.getDuration(), httpRequestRecord.getExceptionRecordId(), httpRequestRecord.getHttpMethod(), httpRequestRecord.getHttpParams(), httpRequestRecord.getProtocol(), httpRequestRecord.getHostname(), httpRequestRecord.getPort(), httpRequestRecord.getContextPath(), httpRequestRecord.getPath(), httpRequestRecord.getQueryString(), httpRequestRecord.getBinaryBody(), httpRequestRecord.getIp(), httpRequestRecord.getUserRoles(), httpRequestRecord.getUserToken(), httpRequestRecord.getTraceId(), httpRequestRecord.getParentId(), httpRequestRecord.getHeaders(), httpRequestRecord.getOtherHeaders());
    }

    public static class ExceptionRecordJspDto {
        private final String id;
        private final Date created;
        private final String serverName;
        private final String type;
        private final String appVersion;
        private final String exceptionLocation;
        private final String callOrigin;
        private final String metricLink;
        private final String callOriginLink;
        private final String exactMetricLink;
        private final ZoneId zoneId;

        public ExceptionRecordJspDto(String id, Date created, String serverName, String type, String appVersion, String exceptionLocation, String callOrigin, String metricLink, String callOriginLink, String exactMetricLink, ZoneId zoneId) {
            this.id = id;
            this.created = created;
            this.serverName = serverName;
            this.type = type;
            this.appVersion = appVersion;
            this.exceptionLocation = exceptionLocation;
            this.callOrigin = callOrigin;
            this.metricLink = metricLink;
            this.callOriginLink = callOriginLink;
            this.exactMetricLink = exactMetricLink;
            this.zoneId = zoneId;
        }

        public String getId() {
            return this.id;
        }

        public String getCreated() {
            return DateTool.formatDateWithZone((Date)this.created, (ZoneId)this.zoneId);
        }

        public String getServerName() {
            return this.serverName;
        }

        public String getType() {
            return this.type;
        }

        public String getAppVersion() {
            return this.appVersion;
        }

        public String getExceptionLocation() {
            return this.exceptionLocation;
        }

        public String getCallOrigin() {
            return this.callOrigin;
        }

        public String getMetricLink() {
            return this.metricLink;
        }

        public String getCallOriginLink() {
            return this.callOriginLink;
        }

        public String getExactMetricLink() {
            return this.exactMetricLink;
        }
    }

    public static class HttpRequestRecordJspDto {
        private final Date created;
        private final Date receivedAt;
        private final Long duration;
        private final String exceptionRecordId;
        private final String httpMethod;
        private final String httpParams;
        private final String protocol;
        private final String hostname;
        private final int port;
        private final String contextPath;
        private final String path;
        private final String queryString;
        private final byte[] binaryBody;
        private final String ip;
        private final String userRoles;
        private final String userToken;
        private final String traceId;
        private final String parentId;
        private final Map<String, String> headers;
        private final String otherHeaders;

        public HttpRequestRecordJspDto(Date created, Date receivedAt, Long duration, String exceptionRecordId, String httpMethod, String httpParams, String protocol, String hostname, int port, String contextPath, String path, String queryString, byte[] binaryBody, String ip, String userRoles, String userToken, String traceId, String parentId, Map<String, String> headers, String otherHeaders) {
            this.created = created;
            this.receivedAt = receivedAt;
            this.duration = duration;
            this.exceptionRecordId = exceptionRecordId;
            this.httpMethod = httpMethod;
            this.httpParams = httpParams;
            this.protocol = protocol;
            this.hostname = hostname;
            this.port = port;
            this.contextPath = contextPath;
            this.path = path;
            this.queryString = queryString;
            this.binaryBody = binaryBody;
            this.ip = ip;
            this.userRoles = userRoles;
            this.userToken = userToken;
            this.traceId = traceId;
            this.parentId = parentId;
            this.headers = headers;
            this.otherHeaders = otherHeaders;
        }

        public Map<String, String[]> getOtherHeadersMap() {
            return (Map)GsonTool.GSON.fromJson(this.otherHeaders, new TypeToken<Map<String, String[]>>(){}.getType());
        }

        public Map<String, String[]> getHttpParamsMap() {
            return (Map)GsonTool.GSON.fromJson(this.httpParams, new TypeToken<Map<String, String[]>>(){}.getType());
        }

        public Map<String, String> getCookiesMap() {
            return CookieTool.getMapFromString((String)this.headers.get("cookie"), (String)";", (String)"=");
        }

        public boolean isFromAjax() {
            return "XMLHttpRequest".equals(this.headers.get("x-requested-with"));
        }

        public String getUrl() {
            return String.valueOf(this.getProtocol()) + "://" + this.hostname + ":" + this.port + (this.contextPath == null ? "" : this.contextPath) + this.path + (this.queryString != null ? "?" + this.queryString : "");
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getStringBody() {
            if (this.binaryBody != null) {
                return new String(this.binaryBody);
            }
            return null;
        }

        public Date getCreated() {
            return this.created;
        }

        public Date getReceivedAt() {
            return this.receivedAt;
        }

        public Long getDuration() {
            return this.duration;
        }

        public String getExceptionRecordId() {
            return this.exceptionRecordId;
        }

        public String getHttpMethod() {
            return this.httpMethod;
        }

        public String getHttpParams() {
            return this.httpParams;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public String getPath() {
            return this.path;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public byte[] getBinaryBody() {
            return this.binaryBody;
        }

        public String getIp() {
            return this.ip;
        }

        public String getUserRoles() {
            return this.userRoles;
        }

        public String getUserToken() {
            return this.userToken;
        }

        public String getTraceId() {
            return this.traceId;
        }

        public String getParentId() {
            return this.parentId;
        }
    }
}

