/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.conveyors;

import io.datarouter.conveyor.queue.BaseGroupQueueConsumerConveyor;
import io.datarouter.conveyor.queue.GroupQueueConsumer;
import io.datarouter.exception.storage.httprecord.HttpRequestRecord;
import io.datarouter.exception.storage.httprecord.HttpRequestRecordKey;
import io.datarouter.instrumentation.exception.ExceptionRecordPublisher;
import io.datarouter.instrumentation.exception.HttpRequestRecordBatchDto;
import io.datarouter.instrumentation.response.PublishingResponseDto;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.exception.ExceptionRecorder;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HttpRequestRecordQueueConveyor
extends BaseGroupQueueConsumerConveyor<HttpRequestRecordKey, HttpRequestRecord> {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestRecordQueueConveyor.class);
    private final ExceptionRecordPublisher publisher;

    public HttpRequestRecordQueueConveyor(String name, Supplier<Boolean> shouldRun, GroupQueueConsumer<HttpRequestRecordKey, HttpRequestRecord> consumer, ExceptionRecordPublisher publisher, Supplier<Boolean> compactExceptionLogging, ExceptionRecorder exceptionRecorder) {
        super(name, shouldRun, consumer, compactExceptionLogging, Duration.ofSeconds(30L), exceptionRecorder);
        this.publisher = publisher;
    }

    protected void processDatabeans(List<HttpRequestRecord> dtos) {
        HttpRequestRecordBatchDto batch = (HttpRequestRecordBatchDto)Scanner.of(dtos).map(HttpRequestRecord::toDto).listTo(HttpRequestRecordBatchDto::new);
        PublishingResponseDto response = this.publisher.addHttpRequest(batch);
        if (response.message.equals("discard")) {
            logger.warn("The message was accepted but discarded.");
        }
        if (response.success == null || !response.success.booleanValue()) {
            throw new RuntimeException("failed to publish response=" + response.message);
        }
    }
}

