/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.job;

import io.datarouter.exception.storage.exceptionrecord.DatarouterExceptionRecordDao;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecord;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecordKey;
import io.datarouter.exception.storage.summary.BaseExceptionRecordSummaryKey;
import io.datarouter.exception.storage.summary.DatarouterExceptionRecordSummaryDao;
import io.datarouter.exception.storage.summary.ExceptionRecordSummary;
import io.datarouter.exception.storage.summary.ExceptionRecordSummaryKey;
import io.datarouter.instrumentation.task.TaskTracker;
import io.datarouter.job.BaseJob;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.tuple.Range;
import java.time.Duration;
import java.util.HashMap;
import java.util.Optional;
import javax.inject.Inject;

public class ExceptionRecordAggregationJob
extends BaseJob {
    private static final long PERIOD_MS = Duration.ofHours(1L).toMillis();
    @Inject
    private DatarouterExceptionRecordSummaryDao exceptionRecordSummaryDao;
    @Inject
    private DatarouterExceptionRecordDao exceptionRecordDao;

    public void run(TaskTracker tracker) {
        long firstPeriodToAggregate;
        long now = System.currentTimeMillis();
        long beginningOfCurrentHour = now - now % PERIOD_MS;
        long lastPeriodToAggregate = beginningOfCurrentHour - PERIOD_MS;
        long periodStart = firstPeriodToAggregate = this.exceptionRecordSummaryDao.scanKeys(1).findFirst().map(BaseExceptionRecordSummaryKey::getPeriodStart).map(lastAggregatedPeriodStart -> lastAggregatedPeriodStart + PERIOD_MS).orElse(lastPeriodToAggregate).longValue();
        while (periodStart <= lastPeriodToAggregate) {
            this.aggregateOnePeriod(periodStart);
            periodStart += PERIOD_MS;
        }
    }

    private void aggregateOnePeriod(long periodStart) {
        String startId = String.valueOf(periodStart);
        String endId = String.valueOf(periodStart + PERIOD_MS);
        Range range = new Range((Comparable)((Object)new ExceptionRecordKey(startId)), (Comparable)((Object)new ExceptionRecordKey(endId)));
        HashMap<ExceptionRecordSummaryKey, Long> summaryCounts = new HashMap<ExceptionRecordSummaryKey, Long>();
        HashMap<ExceptionRecordSummaryKey, String> sampledRecordIds = new HashMap<ExceptionRecordSummaryKey, String>();
        for (ExceptionRecord record : this.exceptionRecordDao.scan((Range<ExceptionRecordKey>)range).iterable()) {
            String exceptionLocation = Optional.ofNullable(record.getExceptionLocation()).orElse("");
            String type = Optional.ofNullable(record.getType()).orElse("");
            ExceptionRecordSummaryKey summaryKey = new ExceptionRecordSummaryKey(periodStart, type, exceptionLocation);
            summaryCounts.merge(summaryKey, 1L, Long::sum);
            sampledRecordIds.putIfAbsent(summaryKey, ((ExceptionRecordKey)record.getKey()).getId());
        }
        Scanner.of(summaryCounts.entrySet()).map(entry -> new ExceptionRecordSummary((ExceptionRecordSummaryKey)((Object)((Object)entry.getKey())), (Long)entry.getValue(), (String)sampledRecordIds.get(entry.getKey()))).batch(100).forEach(this.exceptionRecordSummaryDao::putMulti);
    }
}

