/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.service;

import io.datarouter.exception.config.DatarouterExceptionSettingRoot;
import io.datarouter.exception.conveyors.DatarouterExceptionBuffers;
import io.datarouter.exception.service.ExceptionRecordService;
import io.datarouter.exception.storage.exceptionrecord.DatarouterExceptionRecordPublisherDao;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecord;
import io.datarouter.exception.storage.httprecord.DatarouterHttpRequestRecordPublisherDao;
import io.datarouter.exception.storage.httprecord.HttpRequestRecord;
import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.instrumentation.exception.ExceptionRecordDto;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.storage.exception.ExceptionCategory;
import io.datarouter.storage.exception.UnknownExceptionCategory;
import io.datarouter.web.app.WebappName;
import io.datarouter.web.config.DatarouterWebSettingRoot;
import io.datarouter.web.dispatcher.Dispatcher;
import io.datarouter.web.exception.ExceptionCounters;
import io.datarouter.web.exception.ExceptionHandlingConfig;
import io.datarouter.web.exception.ExceptionRecorder;
import io.datarouter.web.exception.WebExceptionCategory;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.monitoring.GitProperties;
import io.datarouter.web.user.session.CurrentSessionInfo;
import io.datarouter.web.user.session.service.Session;
import io.datarouter.web.util.ExceptionTool;
import io.datarouter.web.util.RequestAttributeKey;
import io.datarouter.web.util.RequestAttributeTool;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExceptionRecorder
implements ExceptionRecorder {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionRecorder.class);
    @Inject
    private ExceptionHandlingConfig exceptionHandlingConfig;
    @Inject
    private GitProperties gitProperties;
    @Inject
    private ExceptionRecordService exceptionRecordService;
    @Inject
    private DatarouterExceptionRecordPublisherDao exceptionRecordPublisherDao;
    @Inject
    private DatarouterHttpRequestRecordPublisherDao httpRequestRecordPublisherDao;
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private DatarouterWebSettingRoot datarouterWebSettingRoot;
    @Inject
    private CurrentSessionInfo currentSessionInfo;
    @Inject
    private WebappName webappName;
    @Inject
    private DatarouterService datarouterService;
    @Inject
    private DatarouterExceptionSettingRoot settings;
    @Inject
    private DatarouterExceptionBuffers exceptionBuffers;

    public Optional<ExceptionRecordDto> tryRecordException(Throwable exception, String callOrigin) {
        return this.tryRecordException(exception, callOrigin, (ExceptionCategory)UnknownExceptionCategory.UNKNOWN);
    }

    public Optional<ExceptionRecordDto> tryRecordException(Throwable exception, String callOrigin, ExceptionCategory category) {
        try {
            DefaultExceptionRecorderDetails exceptionDetails = this.detectExceptionLocation(exception);
            return Optional.of(this.recordException(exception, category, exceptionDetails.className, exceptionDetails.methodName, exceptionDetails.lineNumber, callOrigin));
        }
        catch (Exception e) {
            logger.warn("Exception while recording an exception", (Throwable)e);
            return Optional.empty();
        }
    }

    public ExceptionRecordDto recordException(Throwable exception, ExceptionCategory category, String location, String methodName, Integer lineNumber, String callOrigin) {
        if (callOrigin == null) {
            callOrigin = location;
        }
        ExceptionCounters.inc((String)category.name());
        ExceptionCounters.inc((String)(String.valueOf(category.name()) + " " + this.webappName));
        ExceptionCounters.inc((String)exception.getClass().getName());
        ExceptionCounters.inc((String)callOrigin);
        ExceptionCounters.inc((String)(String.valueOf(exception.getClass().getName()) + " " + callOrigin));
        ExceptionRecord exceptionRecord = new ExceptionRecord(this.datarouterService.getServiceName(), this.datarouterProperties.getServerName(), ExceptionTool.getStackTraceAsString((Throwable)exception), exception.getClass().getName(), this.gitProperties.getIdAbbrev().orElse("unknown"), location, methodName, lineNumber, callOrigin);
        this.exceptionBuffers.exceptionRecordBuffer.offer((Object)exceptionRecord);
        logger.warn("Exception recorded ({})", (Object)this.exceptionRecordService.buildExceptionLinkForCurrentServer(exceptionRecord));
        if (((Boolean)this.settings.publishRecords.get()).booleanValue()) {
            this.exceptionRecordPublisherDao.put(exceptionRecord);
        }
        if (this.exceptionHandlingConfig.shouldReportError(exceptionRecord.toDto())) {
            this.report(exceptionRecord, category);
        }
        return exceptionRecord.toDto();
    }

    public Optional<ExceptionRecordDto> tryRecordExceptionAndHttpRequest(Throwable exception, String callOrigin, HttpServletRequest request) {
        try {
            DefaultExceptionRecorderDetails exceptionDetails = this.detectExceptionLocation(exception);
            return Optional.of(this.recordExceptionAndHttpRequest(exception, exceptionDetails.className, exceptionDetails.methodName, exceptionDetails.lineNumber, request, callOrigin));
        }
        catch (Exception e) {
            logger.warn("Exception while recording an exception", (Throwable)e);
            return Optional.empty();
        }
    }

    public ExceptionRecordDto recordExceptionAndHttpRequest(Throwable exception, String location, String methodName, Integer lineNumber, HttpServletRequest request, String callOrigin) {
        ExceptionRecordDto exceptionRecord = this.recordException(exception, (ExceptionCategory)WebExceptionCategory.HTTP_REQUEST, location, methodName, lineNumber, callOrigin);
        this.recordHttpRequest(request, exceptionRecord, true);
        return exceptionRecord;
    }

    protected void report(ExceptionRecord exceptionRecord, ExceptionCategory category) {
    }

    public void recordHttpRequest(HttpServletRequest request) {
        this.recordHttpRequest(request, null, false);
    }

    private void recordHttpRequest(HttpServletRequest request, ExceptionRecordDto exceptionRecord, boolean publish) {
        Optional<String> userToken = this.currentSessionInfo.getSession((ServletRequest)request).map(Session::getUserToken);
        String userRoles = this.currentSessionInfo.getRoles((ServletRequest)request).toString();
        boolean omitPayload = RequestAttributeTool.get((ServletRequest)request, (RequestAttributeKey)Dispatcher.TRANSMITS_PII).orElse(false);
        HttpRequestRecord httpRequestRecord = new HttpRequestRecord(exceptionRecord == null ? null : exceptionRecord.id, RequestAttributeTool.get((ServletRequest)request, (RequestAttributeKey)BaseHandler.TRACE_CONTEXT), request, userRoles, userToken.orElse(null), omitPayload);
        httpRequestRecord.trimFields();
        this.exceptionBuffers.httpRequestRecordBuffer.offer((Object)httpRequestRecord);
        httpRequestRecord.trimBinaryBody(10000);
        if (publish && ((Boolean)this.settings.publishRecords.get()).booleanValue()) {
            this.httpRequestRecordPublisherDao.put(httpRequestRecord);
        }
    }

    private DefaultExceptionRecorderDetails detectExceptionLocation(Throwable wholeException) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)wholeException);
        Throwable exception = Optional.ofNullable(rootCause).orElse(wholeException);
        StackTraceElement stackTraceElement = this.searchClassName(exception).orElseGet(() -> {
            StackTraceElement[] stackTrace = exception.getStackTrace();
            return stackTrace.length == 0 ? null : stackTrace[0];
        });
        if (stackTraceElement == null) {
            return new DefaultExceptionRecorderDetails("noClass", "noMethod", 0);
        }
        return new DefaultExceptionRecorderDetails(stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber());
    }

    private Optional<StackTraceElement> searchClassName(Throwable cause) {
        StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            for (String highlight : (Set)this.datarouterWebSettingRoot.stackTraceHighlights.get()) {
                if (!element.getClassName().contains(highlight)) continue;
                return Optional.of(element);
            }
            ++n2;
        }
        return Optional.empty();
    }

    private static class DefaultExceptionRecorderDetails {
        public final String className;
        public final String methodName;
        public final int lineNumber;

        protected DefaultExceptionRecorderDetails(String className, String methodName, int lineNumber) {
            this.className = className;
            this.methodName = methodName;
            this.lineNumber = lineNumber;
        }
    }
}

