/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.service;

import io.datarouter.email.html.J2HtmlEmailTable;
import io.datarouter.exception.config.DatarouterExceptionPaths;
import io.datarouter.exception.service.ExemptDailyDigestExceptions;
import io.datarouter.exception.storage.summary.DatarouterExceptionRecordSummaryDao;
import io.datarouter.exception.storage.summary.ExceptionRecordSummary;
import io.datarouter.exception.storage.summary.ExceptionRecordSummaryKey;
import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.number.NumberFormatter;
import io.datarouter.util.time.LocalDateTimeTool;
import io.datarouter.web.config.ServletContextSupplier;
import io.datarouter.web.digest.DailyDigest;
import io.datarouter.web.digest.DailyDigestGrouping;
import io.datarouter.web.digest.DailyDigestService;
import io.datarouter.web.html.j2html.J2HtmlTable;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.SmallTag;
import j2html.tags.specialized.TdTag;
import java.time.ZoneId;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletContext;

@Singleton
public class ExceptionRecordAggregationDailyDigest
implements DailyDigest {
    private static final int EXCEPTIONS_THRESHOLD = 100;
    private static final Comparator<AggregatedExceptionDto> COMPARATOR = Comparator.comparing(dto -> dto.value.count).reversed();
    @Inject
    private DatarouterExceptionRecordSummaryDao dao;
    @Inject
    private DatarouterExceptionPaths paths;
    @Inject
    private ServletContextSupplier contextSupplier;
    @Inject
    private DailyDigestService digestService;
    @Inject
    private ExemptDailyDigestExceptions exemptDailyDigestExceptions;
    @Inject
    private DatarouterService datarouterService;

    public Optional<ContainerTag<?>> getPageContent(ZoneId zoneId) {
        List<AggregatedExceptionDto> aggregated = this.getExceptions(zoneId);
        if (aggregated.size() == 0) {
            return Optional.empty();
        }
        ContainerTag header = this.digestService.makeHeader("Exceptions", this.paths.datarouter.exception.browse);
        SmallTag description = TagCreator.small((String)"Aggregated for the current day (over 100)");
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, description, this.makePageTable(aggregated)}));
    }

    public Optional<ContainerTag<?>> getEmailContent() {
        List<AggregatedExceptionDto> aggregated = this.getExceptions(this.datarouterService.getZoneId());
        if (aggregated.size() == 0) {
            return Optional.empty();
        }
        ContainerTag header = this.digestService.makeHeader("Exceptions", this.paths.datarouter.exception.browse);
        SmallTag description = TagCreator.small((String)"Aggregated for the current day (over 100)");
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, description, this.makeEmailTable(aggregated)}));
    }

    public String getTitle() {
        return "Exception Records";
    }

    public DailyDigestGrouping getGrouping() {
        return DailyDigestGrouping.HIGH;
    }

    public DailyDigest.DailyDigestType getType() {
        return DailyDigest.DailyDigestType.SUMMARY;
    }

    private List<AggregatedExceptionDto> getExceptions(ZoneId zoneId) {
        HashMap<AggregatedExceptionKeyDto, AggregatedExceptionValueDto> aggregatedExceptions = new HashMap<AggregatedExceptionKeyDto, AggregatedExceptionValueDto>();
        for (ExceptionRecordSummary exception : this.dao.scan().advanceUntil(key -> ((ExceptionRecordSummaryKey)key.getKey()).getReversePeriodStart() > LocalDateTimeTool.atStartOfDayReversedMs((ZoneId)zoneId)).iterable()) {
            if (this.exemptDailyDigestExceptions.isExempt(exception)) continue;
            AggregatedExceptionKeyDto key2 = new AggregatedExceptionKeyDto((ExceptionRecordSummaryKey)exception.getKey());
            AggregatedExceptionValueDto value = new AggregatedExceptionValueDto(exception);
            AggregatedExceptionValueDto mapValue = (AggregatedExceptionValueDto)aggregatedExceptions.get(key2);
            if (mapValue != null) {
                value.addCount(mapValue.count);
            }
            aggregatedExceptions.put(key2, value);
        }
        return Scanner.of(aggregatedExceptions.entrySet()).exclude(entry -> ((AggregatedExceptionValueDto)entry.getValue()).count < 100L).map(entry -> new AggregatedExceptionDto((AggregatedExceptionKeyDto)entry.getKey(), (AggregatedExceptionValueDto)entry.getValue())).sort(COMPARATOR).list();
    }

    private ContainerTag<?> makePageTable(List<AggregatedExceptionDto> rows) {
        return new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withColumn("Type", row -> row.key.type).withColumn("Location", row -> row.key.location).withHtmlColumn((DomContent)TagCreator.th((String)"Count").withStyle("text-align:right"), row -> this.makeNumericPageTableCell(row.value.count)).withHtmlColumn("Details", row -> TagCreator.td((DomContent[])new DomContent[]{((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.i().withClass("far fa-file-alt")}).withClass("btn btn-link w-100 py-0")).withHref(String.valueOf(((ServletContext)this.contextSupplier.get()).getContextPath()) + this.makeExceptionRecordPath((AggregatedExceptionDto)row))})).withCaption("Total " + rows.size()).build(rows);
    }

    private ContainerTag<?> makeEmailTable(List<AggregatedExceptionDto> rows) {
        return new J2HtmlEmailTable().withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn("Type", row -> this.digestService.makeATagLink(row.key.type, this.makeExceptionRecordPath((AggregatedExceptionDto)row)))).withColumn("Location", row -> row.key.location).withColumn(J2HtmlEmailTable.J2HtmlEmailTableColumn.ofNumber((String)"Count", row -> row.value.count)).build(rows);
    }

    private ContainerTag<?> makeNumericPageTableCell(long value) {
        return (ContainerTag)((TdTag)TagCreator.td((String)NumberFormatter.addCommas((Number)value)).attr("sorttable_customkey", (Object)value)).withStyle("text-align:right");
    }

    private String makeExceptionRecordPath(AggregatedExceptionDto dto) {
        return String.valueOf(this.paths.datarouter.exception.details.toSlashedString()) + "?" + "exceptionRecord" + "=" + dto.value.detailsLink;
    }

    private static class AggregatedExceptionDto {
        public final AggregatedExceptionKeyDto key;
        public final AggregatedExceptionValueDto value;

        public AggregatedExceptionDto(AggregatedExceptionKeyDto key, AggregatedExceptionValueDto value) {
            this.key = key;
            this.value = value;
        }
    }

    private static class AggregatedExceptionKeyDto {
        public final String type;
        public final String location;

        public AggregatedExceptionKeyDto(ExceptionRecordSummaryKey key) {
            this.type = key.getType();
            this.location = key.getExceptionLocation();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AggregatedExceptionKeyDto)) {
                return false;
            }
            AggregatedExceptionKeyDto that = (AggregatedExceptionKeyDto)other;
            return this.type.equals(that.type) && this.location.equals(that.location);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.location);
        }
    }

    private static class AggregatedExceptionValueDto {
        public final String detailsLink;
        public long count;

        public AggregatedExceptionValueDto(ExceptionRecordSummary summary) {
            this.count = summary.getNumExceptions();
            this.detailsLink = summary.getSampleExceptionRecordId();
        }

        public void addCount(long count) {
            this.count += count;
        }
    }
}

