/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.storage.exceptionrecord;

import io.datarouter.exception.storage.exceptionrecord.BaseExceptionRecordKey;
import io.datarouter.instrumentation.exception.ExceptionRecordDto;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.DateField;
import io.datarouter.model.field.imp.DateFieldKey;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.comparable.IntegerField;
import io.datarouter.model.field.imp.comparable.IntegerFieldKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.model.serialize.fielder.Fielder;
import io.datarouter.web.service.DatarouterServiceFieldKeys;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;

public abstract class BaseExceptionRecord<PK extends BaseExceptionRecordKey<PK>, D extends BaseExceptionRecord<PK, D>>
extends BaseDatabean<PK, D> {
    private Date created;
    private String serviceName;
    private String serverName;
    private String stackTrace;
    private String type;
    private String appVersion;
    private String exceptionLocation;
    private String methodName;
    private Integer lineNumber;
    private String callOrigin;

    public BaseExceptionRecord(PK key) {
        super(key);
    }

    public BaseExceptionRecord(PK key, String serviceName, String serverName, String stackTrace, String type, String appVersion, String exceptionLocation, String methodName, Integer lineNumber, String callOrigin) {
        this(key, System.currentTimeMillis(), serviceName, serverName, stackTrace, type, appVersion, exceptionLocation, methodName, lineNumber, callOrigin);
    }

    public BaseExceptionRecord(PK key, long dateMs, String serviceName, String serverName, String stackTrace, String type, String appVersion, String exceptionLocation, String methodName, Integer lineNumber, String callOrigin) {
        super(key);
        this.created = new Date(dateMs);
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.stackTrace = stackTrace;
        this.type = type;
        this.appVersion = appVersion;
        this.exceptionLocation = exceptionLocation;
        this.methodName = methodName;
        this.lineNumber = lineNumber;
        this.callOrigin = callOrigin;
    }

    public BaseExceptionRecord(PK key, ExceptionRecordDto exceptionRecordDto) {
        super(key);
        this.created = exceptionRecordDto.created;
        this.serviceName = exceptionRecordDto.serviceName;
        this.serverName = exceptionRecordDto.serverName;
        this.stackTrace = exceptionRecordDto.stackTrace;
        this.type = exceptionRecordDto.type;
        this.appVersion = exceptionRecordDto.appVersion;
        this.exceptionLocation = exceptionRecordDto.exceptionLocation;
        this.methodName = exceptionRecordDto.methodName;
        this.lineNumber = exceptionRecordDto.lineNumber;
        this.callOrigin = exceptionRecordDto.callOrigin;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public String getType() {
        return this.type;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getExceptionLocation() {
        return this.exceptionLocation;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public String getCallOrigin() {
        return this.callOrigin;
    }

    public static abstract class BaseExceptionRecordFielder<PK extends BaseExceptionRecordKey<PK>, D extends BaseExceptionRecord<PK, D>>
    extends BaseDatabeanFielder<PK, D> {
        public BaseExceptionRecordFielder(Supplier<? extends Fielder<PK>> primaryKeyFielderSupplier) {
            super(primaryKeyFielderSupplier);
        }

        public List<Field<?>> getNonKeyFields(D databean) {
            return List.of(new DateField(FieldKeys.created, ((BaseExceptionRecord)((Object)databean)).getCreated()), new StringField(DatarouterServiceFieldKeys.serviceName, ((BaseExceptionRecord)((Object)databean)).getServiceName()), new StringField(FieldKeys.serverName, ((BaseExceptionRecord)((Object)databean)).getServerName()), new StringField(FieldKeys.stackTrace, ((BaseExceptionRecord)((Object)databean)).getStackTrace()), new StringField(FieldKeys.type, ((BaseExceptionRecord)((Object)databean)).getType()), new StringField(FieldKeys.appVersion, ((BaseExceptionRecord)((Object)databean)).getAppVersion()), new StringField(FieldKeys.exceptionLocation, ((BaseExceptionRecord)((Object)databean)).getExceptionLocation()), new StringField(FieldKeys.methodName, ((BaseExceptionRecord)((Object)databean)).getMethodName()), new IntegerField(FieldKeys.lineNumber, ((BaseExceptionRecord)((Object)databean)).getLineNumber()), new StringField(FieldKeys.callOrigin, ((BaseExceptionRecord)((Object)databean)).getCallOrigin()));
        }
    }

    public static class FieldKeys {
        public static final DateFieldKey created = new DateFieldKey("created");
        public static final StringFieldKey serverName = new StringFieldKey("serverName");
        public static final StringFieldKey stackTrace = new StringFieldKey("stackTrace").withSize(0xFFFFFF);
        public static final StringFieldKey type = new StringFieldKey("type");
        public static final StringFieldKey appVersion = new StringFieldKey("appVersion");
        public static final StringFieldKey exceptionLocation = new StringFieldKey("exceptionLocation");
        public static final StringFieldKey methodName = new StringFieldKey("methodName");
        public static final IntegerFieldKey lineNumber = new IntegerFieldKey("lineNumber");
        public static final StringFieldKey callOrigin = new StringFieldKey("callOrigin");
    }
}

