/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.storage.exceptionrecord;

import io.datarouter.exception.storage.exceptionrecord.ExceptionRecord;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecordKey;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseRedundantDaoParams;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.util.DatabeanVacuum;
import io.datarouter.util.tuple.Range;
import io.datarouter.virtualnode.redundant.RedundantSortedMapStorageNode;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterExceptionRecordDao
extends BaseDao {
    private final SortedMapStorage.SortedMapStorageNode<ExceptionRecordKey, ExceptionRecord, ExceptionRecord.ExceptionRecordFielder> node;

    @Inject
    public DatarouterExceptionRecordDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterExceptionRecordDaoParams params) {
        super(datarouter);
        this.node = (SortedMapStorage.SortedMapStorageNode)Scanner.of((Iterable)params.clientIds).map(clientId -> {
            SortedMapStorage.SortedMapStorageNode node = (SortedMapStorage.SortedMapStorageNode)nodeFactory.create(clientId, ExceptionRecord::new, ExceptionRecord.ExceptionRecordFielder::new).withIsSystemTable(true).build();
            return node;
        }).listTo(RedundantSortedMapStorageNode::new);
        datarouter.register(this.node);
    }

    public ExceptionRecord get(ExceptionRecordKey key) {
        return (ExceptionRecord)this.node.get((PrimaryKey)key);
    }

    public void put(ExceptionRecord databean) {
        this.node.put((Databean)databean);
    }

    public void putMulti(Collection<ExceptionRecord> databeans) {
        this.node.putMulti(databeans);
    }

    public Scanner<ExceptionRecord> scan(Range<ExceptionRecordKey> range) {
        return this.node.scan(range);
    }

    public DatabeanVacuum<ExceptionRecordKey, ExceptionRecord> makeVacuum() {
        Duration lifespan = Duration.ofDays(14L);
        return new DatabeanVacuum.DatabeanVacuumBuilder(this.node.scan(), databean -> System.currentTimeMillis() - databean.getCreated().getTime() > lifespan.toMillis(), arg_0 -> this.node.deleteMulti(arg_0)).build();
    }

    public static class DatarouterExceptionRecordDaoParams
    extends BaseRedundantDaoParams {
        public DatarouterExceptionRecordDaoParams(List<ClientId> clientIds) {
            super(clientIds);
        }
    }
}

