/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.storage.exceptionrecord;

import io.datarouter.exception.storage.exceptionrecord.BaseExceptionRecord;
import io.datarouter.exception.storage.exceptionrecord.ExceptionRecordKey;
import io.datarouter.instrumentation.exception.ExceptionRecordDto;
import io.datarouter.model.databean.Databean;
import io.datarouter.util.lang.ClassTool;
import java.util.function.Supplier;

public class ExceptionRecord
extends BaseExceptionRecord<ExceptionRecordKey, ExceptionRecord> {
    public ExceptionRecord() {
        super(new ExceptionRecordKey());
    }

    public ExceptionRecord(String serviceName, String serverName, String stackTrace, String type, String appVersion, String exceptionLocation, String methodName, Integer lineNumber, String callOrigin) {
        this(System.currentTimeMillis(), serviceName, serverName, stackTrace, type, appVersion, exceptionLocation, methodName, lineNumber, callOrigin);
    }

    public ExceptionRecord(long dateMs, String serviceName, String serverName, String stackTrace, String type, String appVersion, String exceptionLocation, String methodName, Integer lineNumber, String callOrigin) {
        super(ExceptionRecordKey.generate(), dateMs, serviceName, serverName, stackTrace, type, appVersion, exceptionLocation, methodName, lineNumber, callOrigin);
    }

    public Supplier<ExceptionRecordKey> getKeySupplier() {
        return ExceptionRecordKey::new;
    }

    public int compareTo(Databean<?, ?> that) {
        int diff = ClassTool.compareClass((Object)((Object)this), that);
        if (diff != 0) {
            return diff;
        }
        return this.getCreated().compareTo(((ExceptionRecord)that).getCreated());
    }

    public ExceptionRecordDto toDto() {
        return new ExceptionRecordDto(((ExceptionRecordKey)this.getKey()).getId(), this.getCreated(), this.getServiceName(), this.getServerName(), this.getStackTrace(), this.getType(), this.getAppVersion(), this.getExceptionLocation(), this.getMethodName(), this.getLineNumber(), this.getCallOrigin());
    }

    public static class ExceptionRecordFielder
    extends BaseExceptionRecord.BaseExceptionRecordFielder<ExceptionRecordKey, ExceptionRecord> {
        public ExceptionRecordFielder() {
            super(ExceptionRecordKey::new);
        }
    }
}

