/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.exception.storage.httprecord;

import io.datarouter.exception.storage.httprecord.BaseHttpRequestRecordKey;
import io.datarouter.instrumentation.exception.HttpRequestRecordDto;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.DateField;
import io.datarouter.model.field.imp.DateFieldKey;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.array.ByteArrayField;
import io.datarouter.model.field.imp.array.ByteArrayFieldKey;
import io.datarouter.model.field.imp.comparable.IntegerField;
import io.datarouter.model.field.imp.comparable.IntegerFieldKey;
import io.datarouter.model.field.imp.comparable.LongField;
import io.datarouter.model.field.imp.comparable.LongFieldKey;
import io.datarouter.model.field.imp.custom.LongDateField;
import io.datarouter.model.field.imp.custom.LongDateFieldKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.model.serialize.fielder.Fielder;
import io.datarouter.util.array.ArrayTool;
import io.datarouter.util.serialization.GsonTool;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.monitoring.exception.ExceptionDto;
import io.datarouter.web.util.http.RecordedHttpHeaders;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHttpRequestRecord<PK extends BaseHttpRequestRecordKey<PK>, D extends BaseHttpRequestRecord<PK, D>>
extends BaseDatabean<PK, D> {
    private static final Logger logger = LoggerFactory.getLogger(BaseHttpRequestRecord.class);
    private Date created;
    private Date receivedAt;
    private Long duration;
    private String exceptionRecordId;
    private String traceId;
    private String parentId;
    private String httpMethod;
    private String httpParams;
    private String protocol;
    private String hostname;
    private int port;
    private String contextPath;
    private String path;
    private String queryString;
    private byte[] binaryBody;
    private String ip;
    private String userRoles;
    private String userToken;
    private String acceptCharset;
    private String acceptEncoding;
    private String acceptLanguage;
    private String accept;
    private String cacheControl;
    private String connection;
    private String contentEncoding;
    private String contentLanguage;
    private String contentLength;
    private String contentType;
    private String cookie;
    private String dnt;
    private String host;
    private String ifModifiedSince;
    private String origin;
    private String pragma;
    private String referer;
    private String userAgent;
    private String xForwardedFor;
    private String xRequestedWith;
    private String otherHeaders;

    public BaseHttpRequestRecord(PK key) {
        super(key);
    }

    public BaseHttpRequestRecord(PK key, Date receivedAt, String exceptionRecordId, String traceId, String parentId, String httpMethod, String httpParams, String protocol, String hostname, int port, String contextPath, String path, String queryString, byte[] binaryBody, String ip, String sessionRoles, String userToken, RecordedHttpHeaders headersWrapper) {
        super(key);
        this.created = new Date();
        this.receivedAt = receivedAt;
        if (receivedAt != null) {
            this.duration = this.created.getTime() - receivedAt.getTime();
        }
        this.exceptionRecordId = exceptionRecordId;
        this.traceId = traceId;
        this.parentId = parentId;
        this.httpMethod = httpMethod;
        this.httpParams = httpParams;
        this.protocol = protocol;
        this.hostname = hostname;
        this.port = port;
        this.contextPath = contextPath;
        this.path = path;
        this.queryString = queryString;
        this.binaryBody = binaryBody;
        this.ip = ip;
        this.userRoles = sessionRoles;
        this.userToken = userToken;
        this.acceptCharset = headersWrapper.getAcceptCharset();
        this.acceptEncoding = headersWrapper.getAcceptEncoding();
        this.acceptLanguage = headersWrapper.getAcceptLanguage();
        this.accept = headersWrapper.getAccept();
        this.cacheControl = headersWrapper.getCacheControl();
        this.connection = headersWrapper.getConnection();
        this.contentEncoding = headersWrapper.getContentEncoding();
        this.contentLanguage = headersWrapper.getContentLanguage();
        this.contentLength = headersWrapper.getContentLength();
        this.contentType = headersWrapper.getContentType();
        this.cookie = headersWrapper.getCookie();
        this.dnt = headersWrapper.getDnt();
        this.host = headersWrapper.getHost();
        this.ifModifiedSince = headersWrapper.getIfModifiedSince();
        this.origin = headersWrapper.getOrigin();
        this.pragma = headersWrapper.getPragma();
        this.referer = headersWrapper.getReferer();
        this.userAgent = headersWrapper.getUserAgent();
        this.xForwardedFor = headersWrapper.getXForwardedFor();
        this.xRequestedWith = headersWrapper.getXRequestedWith();
        this.otherHeaders = headersWrapper.getOthers();
    }

    public BaseHttpRequestRecord(PK key, HttpRequestRecordDto dto) {
        super(key);
        this.created = dto.created;
        this.receivedAt = dto.receivedAt;
        this.duration = dto.duration;
        this.exceptionRecordId = dto.exceptionRecordId;
        this.traceId = dto.traceId;
        this.parentId = dto.parentId;
        this.httpMethod = dto.httpMethod;
        this.httpParams = dto.httpParams;
        this.protocol = dto.protocol;
        this.hostname = dto.hostname;
        this.port = dto.port;
        this.contextPath = dto.contextPath;
        this.path = dto.path;
        this.queryString = dto.queryString;
        this.binaryBody = dto.binaryBody;
        this.ip = dto.ip;
        this.userRoles = dto.userRoles;
        this.userToken = dto.userToken;
        this.acceptCharset = dto.acceptCharset;
        this.acceptEncoding = dto.acceptEncoding;
        this.acceptLanguage = dto.acceptLanguage;
        this.accept = dto.accept;
        this.cacheControl = dto.cacheControl;
        this.connection = dto.connection;
        this.contentEncoding = dto.contentEncoding;
        this.contentLanguage = dto.contentLanguage;
        this.contentLength = dto.contentLength;
        this.contentType = dto.contentType;
        this.cookie = dto.cookie;
        this.dnt = dto.dnt;
        this.host = dto.host;
        this.ifModifiedSince = dto.ifModifiedSince;
        this.origin = dto.origin;
        this.pragma = dto.pragma;
        this.referer = dto.referer;
        this.userAgent = dto.userAgent;
        this.xForwardedFor = dto.xForwardedFor;
        this.xRequestedWith = dto.xRequestedWith;
        this.otherHeaders = dto.otherHeaders;
    }

    public BaseHttpRequestRecord(PK key, ExceptionDto dto, String exceptionRecordId) {
        super(key);
        this.created = new Date(dto.dateMs);
        if (dto.receivedAtMs != null) {
            this.receivedAt = new Date(dto.receivedAtMs);
            this.duration = dto.dateMs - dto.receivedAtMs;
        }
        this.exceptionRecordId = exceptionRecordId;
        this.httpMethod = dto.httpMethod;
        this.httpParams = GsonTool.GSON.toJson((Object)dto.httpParams);
        this.protocol = dto.protocol;
        this.hostname = dto.hostname;
        this.port = dto.port;
        this.path = dto.path;
        this.queryString = dto.queryString;
        this.binaryBody = dto.body == null ? null : dto.body.getBytes();
        this.ip = dto.ip;
        this.userRoles = dto.userRoles;
        this.userToken = dto.userToken;
        this.acceptCharset = dto.acceptCharset;
        this.acceptEncoding = dto.acceptEncoding;
        this.acceptLanguage = dto.acceptLanguage;
        this.accept = dto.accept;
        this.cacheControl = dto.cacheControl;
        this.connection = dto.connection;
        this.contentEncoding = dto.contentEncoding;
        this.contentLanguage = dto.contentLanguage;
        this.contentLength = dto.contentLength;
        this.contentType = dto.contentType;
        this.cookie = dto.cookie;
        this.dnt = dto.dnt;
        this.host = dto.host;
        this.ifModifiedSince = dto.ifModifiedSince;
        this.origin = dto.origin;
        this.pragma = dto.pragma;
        this.referer = dto.referer;
        this.userAgent = dto.userAgent;
        this.xForwardedFor = dto.forwardedFor;
        this.xRequestedWith = dto.requestedWith;
        this.otherHeaders = GsonTool.GSON.toJson((Object)dto.others);
    }

    public Map<String, String> getHeaders() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("accept-charset", this.acceptCharset);
        map.put("accept-encoding", this.acceptEncoding);
        map.put("accept-language", this.acceptLanguage);
        map.put("accept", this.accept);
        map.put("cache-control", this.cacheControl);
        map.put("connection", this.connection);
        map.put("content-encoding", this.contentEncoding);
        map.put("content-language", this.contentLanguage);
        map.put("content-length", this.contentLength);
        map.put("content-type", this.contentType);
        map.put("cookie", this.cookie);
        map.put("dnt", this.dnt);
        map.put("host", this.host);
        map.put("if-modified-since", this.ifModifiedSince);
        map.put("origin", this.origin);
        map.put("pragma", this.pragma);
        map.put("referer", this.referer);
        map.put("user-agent", this.userAgent);
        map.put("x-forwarded-for", this.xForwardedFor);
        map.put("x-requested-with", this.xRequestedWith);
        return map;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getExceptionRecordId() {
        return this.exceptionRecordId;
    }

    public void setExceptionRecordId(String exceptionRecordId) {
        this.exceptionRecordId = exceptionRecordId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getHttpParams() {
        return this.httpParams;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getStringBody() {
        if (this.binaryBody != null) {
            return new String(this.binaryBody);
        }
        return null;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUserRoles() {
        return this.userRoles;
    }

    public String getShorterRoles() {
        return this.userRoles.substring(1, this.userRoles.length() - 1);
    }

    public String getUserToken() {
        return this.userToken;
    }

    public String getAcceptCharset() {
        return this.acceptCharset;
    }

    public String getAcceptEncoding() {
        return this.acceptEncoding;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public String getAccept() {
        return this.accept;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getConnection() {
        return this.connection;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public String getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCookie() {
        return this.cookie;
    }

    public String getDnt() {
        return this.dnt;
    }

    public String getHost() {
        return this.host;
    }

    public String getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getPragma() {
        return this.pragma;
    }

    public String getReferer() {
        return this.referer;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getxForwardedFor() {
        return this.xForwardedFor;
    }

    public String getxRequestedWith() {
        return this.xRequestedWith;
    }

    public String getOtherHeaders() {
        return this.otherHeaders;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Date getReceivedAt() {
        return this.receivedAt;
    }

    public byte[] getBinaryBody() {
        return this.binaryBody;
    }

    public void trimFields() {
        this.trimContentType();
        this.trimAcceptCharset();
        this.trimXForwardedFor();
        this.trimPath();
        this.trimAcceptLanguage();
        this.trimOrigin();
        this.trimPragma();
    }

    public void trimBinaryBody(int size) {
        int originalLength = this.binaryBody.length;
        if (originalLength > size) {
            this.binaryBody = ArrayTool.trimToSize((byte[])this.binaryBody, (int)size);
            logger.warn("Trimmed binary body to {} from {} for sqs, exceptionRecordId={}", new Object[]{size, originalLength, this.exceptionRecordId});
        }
    }

    public void trimContentType() {
        this.contentType = this.trimField(FieldKeys.contentType, this.contentType);
    }

    public void trimAcceptCharset() {
        this.acceptCharset = this.trimField(FieldKeys.acceptCharset, this.acceptCharset);
    }

    public void trimXForwardedFor() {
        this.xForwardedFor = this.trimField(FieldKeys.xForwardedFor, this.xForwardedFor);
    }

    public void trimPath() {
        this.path = this.trimField(FieldKeys.path, this.path);
    }

    public void trimAcceptLanguage() {
        this.acceptLanguage = this.trimField(FieldKeys.acceptLanguage, this.acceptLanguage);
    }

    public void trimOrigin() {
        this.origin = this.trimField(FieldKeys.origin, this.origin);
    }

    public void trimPragma() {
        this.pragma = this.trimField(FieldKeys.pragma, this.pragma);
    }

    private String trimField(StringFieldKey fieldKey, String field) {
        if (field == null) {
            return field;
        }
        int fieldSize = fieldKey.getSize();
        int fieldValueLength = field.length();
        if (fieldValueLength > fieldSize) {
            logger.warn("Trimmed {} to {} from {}, exceptionRecordId={}", new Object[]{fieldKey.getName(), fieldSize, fieldValueLength, this.exceptionRecordId});
            return StringTool.trimToSize((String)field, (int)fieldSize);
        }
        return field;
    }

    public static abstract class BaseHttpRequestRecordFielder<PK extends BaseHttpRequestRecordKey<PK>, D extends BaseHttpRequestRecord<PK, D>>
    extends BaseDatabeanFielder<PK, D> {
        protected BaseHttpRequestRecordFielder(Supplier<? extends Fielder<PK>> primaryKeyFielderSupplier) {
            super(primaryKeyFielderSupplier);
        }

        public List<Field<?>> getNonKeyFields(D record) {
            return List.of(new DateField(FieldKeys.created, ((BaseHttpRequestRecord)((Object)record)).getCreated()), new LongDateField(FieldKeys.receivedAt, ((BaseHttpRequestRecord)((Object)record)).getReceivedAt()), new LongField(FieldKeys.duration, ((BaseHttpRequestRecord)((Object)record)).getDuration()), new StringField(FieldKeys.exceptionRecordId, ((BaseHttpRequestRecord)((Object)record)).getExceptionRecordId()), new StringField(FieldKeys.traceId, ((BaseHttpRequestRecord)((Object)record)).getTraceId()), new StringField(FieldKeys.parentId, ((BaseHttpRequestRecord)((Object)record)).getParentId()), new StringField(FieldKeys.httpMethod, ((BaseHttpRequestRecord)((Object)record)).getHttpMethod()), new StringField(FieldKeys.httpParams, ((BaseHttpRequestRecord)((Object)record)).getHttpParams()), new StringField(FieldKeys.protocol, ((BaseHttpRequestRecord)((Object)record)).getProtocol()), new StringField(FieldKeys.hostname, ((BaseHttpRequestRecord)((Object)record)).getHostname()), new IntegerField(FieldKeys.port, Integer.valueOf(((BaseHttpRequestRecord)((Object)record)).getPort())), new StringField(FieldKeys.contextPath, ((BaseHttpRequestRecord)((Object)record)).getContextPath()), new StringField(FieldKeys.path, ((BaseHttpRequestRecord)((Object)record)).getPath()), new StringField(FieldKeys.queryString, ((BaseHttpRequestRecord)((Object)record)).getQueryString()), new ByteArrayField(FieldKeys.binaryBody, ((BaseHttpRequestRecord)((Object)record)).getBinaryBody()), new StringField(FieldKeys.ip, ((BaseHttpRequestRecord)((Object)record)).getIp()), new StringField(FieldKeys.userRoles, ((BaseHttpRequestRecord)((Object)record)).getUserRoles()), new StringField(FieldKeys.userToken, ((BaseHttpRequestRecord)((Object)record)).getUserToken()), new StringField(FieldKeys.acceptCharset, ((BaseHttpRequestRecord)((Object)record)).getAcceptCharset()), new StringField(FieldKeys.acceptEncoding, ((BaseHttpRequestRecord)((Object)record)).getAcceptEncoding()), new StringField(FieldKeys.acceptLanguage, ((BaseHttpRequestRecord)((Object)record)).getAcceptLanguage()), new StringField(FieldKeys.accept, ((BaseHttpRequestRecord)((Object)record)).getAccept()), new StringField(FieldKeys.cacheControl, ((BaseHttpRequestRecord)((Object)record)).getCacheControl()), new StringField(FieldKeys.connection, ((BaseHttpRequestRecord)((Object)record)).getConnection()), new StringField(FieldKeys.contentEncoding, ((BaseHttpRequestRecord)((Object)record)).getContentEncoding()), new StringField(FieldKeys.contentLanguage, ((BaseHttpRequestRecord)((Object)record)).getContentLanguage()), new StringField(FieldKeys.contentLength, ((BaseHttpRequestRecord)((Object)record)).getContentLength()), new StringField(FieldKeys.contentType, ((BaseHttpRequestRecord)((Object)record)).getContentType()), new StringField(FieldKeys.cookie, ((BaseHttpRequestRecord)((Object)record)).getCookie()), new StringField(FieldKeys.dnt, ((BaseHttpRequestRecord)((Object)record)).getDnt()), new StringField(FieldKeys.host, ((BaseHttpRequestRecord)((Object)record)).getHost()), new StringField(FieldKeys.ifModifiedSince, ((BaseHttpRequestRecord)((Object)record)).getIfModifiedSince()), new StringField(FieldKeys.origin, ((BaseHttpRequestRecord)((Object)record)).getOrigin()), new StringField(FieldKeys.pragma, ((BaseHttpRequestRecord)((Object)record)).getPragma()), new StringField(FieldKeys.referer, ((BaseHttpRequestRecord)((Object)record)).getReferer()), new StringField(FieldKeys.userAgent, ((BaseHttpRequestRecord)((Object)record)).getUserAgent()), new StringField(FieldKeys.xForwardedFor, ((BaseHttpRequestRecord)((Object)record)).getxForwardedFor()), new StringField(FieldKeys.xRequestedWith, ((BaseHttpRequestRecord)((Object)record)).getxRequestedWith()), new StringField(FieldKeys.otherHeaders, ((BaseHttpRequestRecord)((Object)record)).getOtherHeaders()));
        }
    }

    public static class FieldKeys {
        public static final DateFieldKey created = new DateFieldKey("created");
        public static final LongDateFieldKey receivedAt = new LongDateFieldKey("receivedAt");
        public static final LongFieldKey duration = new LongFieldKey("duration");
        public static final StringFieldKey exceptionRecordId = new StringFieldKey("exceptionRecordId");
        public static final StringFieldKey traceId = new StringFieldKey("traceId").withSize(32);
        public static final StringFieldKey parentId = new StringFieldKey("parentId").withSize(16);
        public static final StringFieldKey httpMethod = new StringFieldKey("httpMethod").withSize(16);
        public static final StringFieldKey httpParams = new StringFieldKey("httpParams").withSize(Integer.MAX_VALUE);
        public static final StringFieldKey protocol = new StringFieldKey("protocol").withSize(5);
        public static final StringFieldKey hostname = new StringFieldKey("hostname");
        public static final IntegerFieldKey port = new IntegerFieldKey("port");
        public static final StringFieldKey contextPath = new StringFieldKey("contextPath");
        public static final StringFieldKey path = new StringFieldKey("path");
        public static final StringFieldKey queryString = new StringFieldKey("queryString").withSize(Integer.MAX_VALUE);
        public static final ByteArrayFieldKey binaryBody = new ByteArrayFieldKey("binaryBody").withSize(0xFFFFFF);
        public static final StringFieldKey ip = new StringFieldKey("ip").withSize(39);
        public static final StringFieldKey userRoles = new StringFieldKey("userRoles").withSize(Integer.MAX_VALUE);
        public static final StringFieldKey userToken = new StringFieldKey("userToken");
        public static final StringFieldKey acceptCharset = new StringFieldKey("acceptCharset");
        public static final StringFieldKey acceptEncoding = new StringFieldKey("acceptEncoding");
        public static final StringFieldKey acceptLanguage = new StringFieldKey("acceptLanguage");
        public static final StringFieldKey accept = new StringFieldKey("accept");
        public static final StringFieldKey cacheControl = new StringFieldKey("cacheControl");
        public static final StringFieldKey connection = new StringFieldKey("connection");
        public static final StringFieldKey contentEncoding = new StringFieldKey("contentEncoding");
        public static final StringFieldKey contentLanguage = new StringFieldKey("contentLanguage");
        public static final StringFieldKey contentLength = new StringFieldKey("contentLength");
        public static final StringFieldKey contentType = new StringFieldKey("contentType");
        public static final StringFieldKey cookie = new StringFieldKey("cookie").withSize(Integer.MAX_VALUE);
        public static final StringFieldKey dnt = new StringFieldKey("dnt");
        public static final StringFieldKey host = new StringFieldKey("host");
        public static final StringFieldKey ifModifiedSince = new StringFieldKey("ifModifiedSince");
        public static final StringFieldKey origin = new StringFieldKey("origin");
        public static final StringFieldKey pragma = new StringFieldKey("pragma");
        public static final StringFieldKey referer = new StringFieldKey("referer").withSize(Integer.MAX_VALUE);
        public static final StringFieldKey userAgent = new StringFieldKey("userAgent").withSize(Integer.MAX_VALUE);
        public static final StringFieldKey xForwardedFor = new StringFieldKey("xForwardedFor");
        public static final StringFieldKey xRequestedWith = new StringFieldKey("xRequestedWith");
        public static final StringFieldKey otherHeaders = new StringFieldKey("otherHeaders").withSize(Integer.MAX_VALUE);
    }
}

