/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.graphql.client.util.query;

import io.datarouter.graphql.client.util.query.GraphQlClientTool;
import io.datarouter.graphql.client.util.type.GraphQlArgumentType;
import io.datarouter.graphql.client.util.type.GraphQlRootType;
import io.datarouter.graphql.client.util.type.GraphQlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphQlClientQueryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(GraphQlClientQueryBuilder.class);
    private final List<GraphQlClientQueryBuilder> fieldSubQueries = new ArrayList<GraphQlClientQueryBuilder>();
    private final Map<String, Optional<GraphQlArgumentType>> fieldToArgs = new HashMap<String, Optional<GraphQlArgumentType>>();
    private final GraphQlClientTool.GraphQlParentFieldAndArg parent;
    private final Set<String> fieldsFromType;
    private final Class<? extends GraphQlType> graphQlType;

    public GraphQlClientQueryBuilder(GraphQlRootType rootType, Class<? extends GraphQlType> clazz) {
        this(rootType.getPersistentString(), clazz);
    }

    public GraphQlClientQueryBuilder(String parent, Class<? extends GraphQlType> clazz) {
        this(parent, null, clazz);
    }

    public GraphQlClientQueryBuilder(String parent, GraphQlArgumentType arg, Class<? extends GraphQlType> clazz) {
        this.parent = new GraphQlClientTool.GraphQlParentFieldAndArg(parent, Optional.ofNullable(arg));
        this.fieldsFromType = GraphQlClientTool.createSetOfGraphQlTypeFields(clazz);
        this.graphQlType = clazz;
    }

    public GraphQlClientQueryBuilder field(String fieldName) {
        this.field(fieldName, null);
        return this;
    }

    public GraphQlClientQueryBuilder field(String fieldName, GraphQlArgumentType arg) {
        this.validate(fieldName);
        this.fieldToArgs.put(fieldName, Optional.ofNullable(arg));
        return this;
    }

    public GraphQlClientQueryBuilder fieldWithSubQuery(GraphQlClientQueryBuilder builder) {
        this.validate(builder.parent.fieldName());
        this.fieldSubQueries.add(builder);
        return this;
    }

    private void validate(String fieldName) {
        if (!this.fieldsFromType.contains(fieldName) && !fieldName.contains("...")) {
            logger.error("fieldName={} missing in type={}", (Object)fieldName, this.graphQlType);
        }
    }

    public String build() {
        return GraphQlClientTool.buildGraphQlQuery(this.parent, this.fieldToArgs, this.fieldSubQueries);
    }
}

