/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.graphql.client.util.query;

import io.datarouter.graphql.client.util.query.GraphQlClientQueryBuilder;
import io.datarouter.graphql.client.util.type.GraphQlArgumentType;
import io.datarouter.graphql.client.util.type.GraphQlSerializedName;
import io.datarouter.graphql.client.util.type.GraphQlType;
import io.datarouter.graphql.client.util.type.QlNullableArgumentString;
import io.datarouter.graphql.client.util.type.QlNullableArgumentType;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class GraphQlClientTool {
    private static final Set<Class<?>> GRAPHQL_SIMPLE_TYPES = Set.of(Integer.class, String.class, Boolean.class, Double.class, Long.class, Float.class);

    public static String buildGraphQlQuery(GraphQlParentFieldAndArg parent, Map<String, Optional<GraphQlArgumentType>> queriesToArgs, List<GraphQlClientQueryBuilder> queryBuilders) {
        StringBuilder sb = new StringBuilder();
        sb.append(GraphQlClientTool.buildFieldWithFieldArg(parent.fieldName(), parent.fieldArg()));
        sb.append("{");
        sb.append("\n");
        for (Map.Entry<String, Optional<GraphQlArgumentType>> entry : queriesToArgs.entrySet()) {
            sb.append(GraphQlClientTool.buildFieldWithFieldArg(entry.getKey(), entry.getValue()));
            sb.append("\n");
        }
        for (GraphQlClientQueryBuilder queryBuilder : queryBuilders) {
            sb.append(queryBuilder.build());
        }
        sb.append("}");
        sb.append("\n");
        return sb.toString();
    }

    public static Set<String> createSetOfGraphQlTypeFields(Class<? extends GraphQlType> graphQlType) {
        HashSet<String> fieldNames = new HashSet<String>();
        Field[] fieldArray = graphQlType.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!Modifier.isStatic(field.getModifiers())) {
                GraphQlSerializedName serializedName = field.getAnnotation(GraphQlSerializedName.class);
                if (serializedName != null) {
                    fieldNames.add(serializedName.value());
                } else {
                    fieldNames.add(field.getName());
                }
            }
            ++n2;
        }
        return fieldNames;
    }

    public static String buildArgumentString(GraphQlArgumentType argumentType) {
        return "(" + GraphQlClientTool.buildArgumentStringForObject(argumentType) + ")";
    }

    private static String buildArgumentStringForObject(Object argumentType) {
        ArrayList<CallSite> allArguments = new ArrayList<CallSite>();
        Field[] fieldArray = argumentType.getClass().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                Object value = field.get(argumentType);
                if (value != null && !Modifier.isStatic(field.getModifiers())) {
                    GraphQlSerializedName serializedName = field.getAnnotation(GraphQlSerializedName.class);
                    String fieldName = serializedName != null ? serializedName.value() : field.getName();
                    String argumentStr = fieldName + ":";
                    if (GraphQlType.class.isAssignableFrom(field.getType())) {
                        argumentStr = argumentStr + "{" + GraphQlClientTool.buildArgumentStringForObject(value) + "}";
                    } else if (List.class.isAssignableFrom(field.getType())) {
                        argumentStr = argumentStr + GraphQlClientTool.buildArgumentStringForList((List)value);
                    } else if (String.class.isAssignableFrom(field.getType())) {
                        argumentStr = argumentStr + "\"" + value.toString() + "\"";
                    } else if (QlNullableArgumentType.class.isAssignableFrom(field.getType())) {
                        argumentStr = argumentStr + GraphQlClientTool.buildArgumentForNullableArgumentType((QlNullableArgumentType)value);
                    } else if (GRAPHQL_SIMPLE_TYPES.contains(field.getType())) {
                        argumentStr = argumentStr + value.toString();
                    } else {
                        throw new RuntimeException("unknownType=" + String.valueOf(field.getType()));
                    }
                    allArguments.add((CallSite)((Object)argumentStr));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
        return String.join((CharSequence)",", allArguments);
    }

    public static String buildArgumentStringForList(List<?> inputList) {
        ArrayList<Object> strings = new ArrayList<Object>();
        for (Object item : inputList) {
            if (String.class.isAssignableFrom(item.getClass())) {
                strings.add("\"" + item.toString() + "\"");
                continue;
            }
            if (GRAPHQL_SIMPLE_TYPES.contains(item.getClass())) {
                strings.add(item.toString());
                continue;
            }
            strings.add("{" + GraphQlClientTool.buildArgumentStringForObject(item) + "}");
        }
        return "[" + String.join((CharSequence)",", strings) + "]";
    }

    private static String buildFieldWithFieldArg(String fieldName, Optional<GraphQlArgumentType> fieldArgOpt) {
        return fieldArgOpt.map(fieldArg -> fieldName + GraphQlClientTool.buildArgumentString(fieldArg)).orElse(fieldName);
    }

    private static String buildArgumentForNullableArgumentType(QlNullableArgumentType<?> argumentType) {
        if (argumentType.toString() == null) {
            return null;
        }
        if (QlNullableArgumentString.class.isAssignableFrom(argumentType.getClass())) {
            return "\"" + String.valueOf(argumentType) + "\"";
        }
        return argumentType.toString();
    }

    public record GraphQlParentFieldAndArg(String fieldName, Optional<GraphQlArgumentType> fieldArg) {
    }
}

