/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.graphql.client.util.response;

import io.datarouter.graphql.client.util.response.DatarouterGraphQlErrorCode;
import java.util.Optional;

public class GraphQlErrorDto {
    public final String code;
    public final String message;
    public final String path;

    public static GraphQlErrorDto with(String code, String message, Optional<String> path) {
        return new GraphQlErrorDto(code, message, path.orElse(""));
    }

    public static GraphQlErrorDto invalidInput(String message) {
        return GraphQlErrorDto.invalidInput(message, Optional.empty());
    }

    public static GraphQlErrorDto invalidInput(String message, Optional<String> path) {
        return GraphQlErrorDto.with(DatarouterGraphQlErrorCode.INVALID_INPUT.name(), message, path);
    }

    public static GraphQlErrorDto internalError(String message) {
        return GraphQlErrorDto.internalError(message, Optional.empty());
    }

    public static GraphQlErrorDto internalError(String message, Optional<String> path) {
        return GraphQlErrorDto.with(DatarouterGraphQlErrorCode.INTERNAL_ERROR.name(), message, path);
    }

    public static GraphQlErrorDto illegalQuery(String message) {
        return GraphQlErrorDto.illegalQuery(message, Optional.empty());
    }

    public static GraphQlErrorDto illegalQuery(String message, Optional<String> path) {
        return GraphQlErrorDto.with(DatarouterGraphQlErrorCode.ILLEGAL_QUERY.name(), message, path);
    }

    private GraphQlErrorDto(String code, String message, String path) {
        this.code = code;
        this.message = message;
        this.path = path;
    }
}

