/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.graphql.client.util.response;

import io.datarouter.graphql.client.util.response.GraphQlErrorDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GraphQlResultDto<T> {
    public final T data;
    public final List<GraphQlErrorDto> errors;
    public final Map<Object, Object> extensions;

    private GraphQlResultDto(T data, List<GraphQlErrorDto> errors, Map<Object, Object> extensions) {
        this.data = data;
        this.errors = errors;
        this.extensions = extensions;
    }

    private GraphQlResultDto(T data, List<GraphQlErrorDto> errors) {
        this(data, errors, null);
    }

    public boolean failed() {
        return this.data == null && this.errors != null && !this.errors.isEmpty();
    }

    public static <T> GraphQlResultDto<T> with(T data, List<GraphQlErrorDto> errors) {
        return new GraphQlResultDto<T>(data, errors);
    }

    public static <T> GraphQlResultDto<T> with(T data, GraphQlErrorDto error) {
        return GraphQlResultDto.with(data, List.of(error));
    }

    public static <T> GraphQlResultDto<T> withData(T data) {
        return GraphQlResultDto.with(data, new ArrayList<GraphQlErrorDto>());
    }

    public static <T> GraphQlResultDto<T> withErrors(List<GraphQlErrorDto> errors) {
        return GraphQlResultDto.with(null, errors);
    }

    public static <T> GraphQlResultDto<T> withError(GraphQlErrorDto error) {
        return GraphQlResultDto.withErrors(List.of(error));
    }

    public static <T> GraphQlResultDto<T> withGraphQlExtensions(T data, List<GraphQlErrorDto> errors, Map<Object, Object> extensions) {
        return new GraphQlResultDto<T>(data, errors, extensions);
    }
}

