/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.gson.serialization;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CompatibleDateTypeAdapter
extends TypeAdapter<Date> {
    private final List<DateFormat> dateFormats = new ArrayList<DateFormat>();

    public CompatibleDateTypeAdapter() {
        this.dateFormats.add(new SimpleDateFormat("MMM d, yyyy h:mm:ss a"));
        this.dateFormats.add(new SimpleDateFormat("MMM d, yyyy, h:mm:ss a"));
    }

    public Date read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        return this.deserializeToDate(in.nextString());
    }

    private synchronized Date deserializeToDate(String json) {
        for (DateFormat dateFormat : this.dateFormats) {
            try {
                return dateFormat.parse(json);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        try {
            return ISO8601Utils.parse((String)json, (ParsePosition)new ParsePosition(0));
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(json, (Throwable)e);
        }
    }

    public synchronized void write(JsonWriter out, Date value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        String dateFormatAsString = this.dateFormats.get(0).format(value);
        out.value(dateFormatAsString);
    }
}

