/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.gson.serialization;

import io.datarouter.gson.Java9;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GsonReflectionTool {
    private static Set<Class<?>> getAllSuperClassesAndInterfaces(Class<?> cls) {
        LinkedHashSet supersAndInterfaces = new LinkedHashSet();
        Class<?>[] classArray = cls.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaceClass = classArray[n2];
            supersAndInterfaces.add(interfaceClass);
            supersAndInterfaces.addAll(GsonReflectionTool.getAllSuperClassesAndInterfaces(interfaceClass));
            ++n2;
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            supersAndInterfaces.add(superclass);
            supersAndInterfaces.addAll(GsonReflectionTool.getAllSuperClassesAndInterfaces(superclass));
        }
        return supersAndInterfaces;
    }

    private static List<Field> getDeclaredFieldsFromAncestors(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> cls : GsonReflectionTool.getAllSuperClassesAndInterfaces(clazz)) {
            Field[] fieldArray = cls.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                fields.add(field);
                ++n2;
            }
        }
        return fields;
    }

    public static List<Field> getDeclaredFieldsIncludingAncestors(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(GsonReflectionTool.getDeclaredFields(clazz));
        fields.addAll(GsonReflectionTool.getDeclaredFieldsFromAncestors(clazz));
        return fields;
    }

    private static List<Field> getDeclaredFields(Class<?> cls) {
        return Java9.listOf(cls.getDeclaredFields());
    }
}

