/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.gson.serialization;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.datarouter.gson.serialization.GsonReflectionTool;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class OptionalContainerClassTypeAdapterFactory
implements TypeAdapterFactory {
    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        boolean hasOptionals = Arrays.stream(rawType.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).anyMatch(field -> field.getType() == Optional.class);
        return hasOptionals ? this.getClassAdapter(gson, type) : null;
    }

    private <T> TypeAdapter<T> getClassAdapter(Gson gson, TypeToken<T> type) {
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                JsonElement tree = delegate.toJsonTree(value);
                OptionalContainerClassTypeAdapterFactory.this.processOptionalFields(value, tree);
                elementAdapter.write(out, (Object)tree);
            }

            public T read(JsonReader in) throws IOException {
                JsonElement tree = (JsonElement)elementAdapter.read(in);
                return delegate.fromJsonTree(tree);
            }
        };
    }

    protected <T> void processOptionalFields(T source, JsonElement toSerialize) {
        JsonObject custom = toSerialize.getAsJsonObject();
        List<Field> fields = GsonReflectionTool.getDeclaredFieldsIncludingAncestors(source.getClass());
        fields.stream().filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> field.getType() == Optional.class).forEach(field -> {
            field.setAccessible(true);
            try {
                if (field.get(source) == null) {
                    custom.remove(this.getName((Field)field));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException("Could not test Optional value", e);
            }
        });
    }

    private String getName(Field field) {
        SerializedName anotation = field.getAnnotation(SerializedName.class);
        if (anotation == null) {
            return field.getName();
        }
        return anotation.value();
    }
}

