/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.gson.serialization;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.datarouter.gson.Java11;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;

public class OptionalTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        if (typeToken.getRawType() != Optional.class) {
            return null;
        }
        Type actualType = ((ParameterizedType)typeToken.getType()).getActualTypeArguments()[0];
        TypeAdapter typeAdapter = gson.getAdapter(TypeToken.get((Type)actualType));
        return new OptionalTypeAdapter(typeAdapter);
    }

    private static class OptionalTypeAdapter<E>
    extends TypeAdapter<Optional<E>> {
        private final TypeAdapter<E> typeAdapter;

        public OptionalTypeAdapter(TypeAdapter<E> typeAdapter) {
            this.typeAdapter = typeAdapter;
        }

        public void write(JsonWriter out, Optional<E> value) throws IOException {
            if (value == null || Java11.isEmpty(value)) {
                out.nullValue();
            } else {
                this.typeAdapter.write(out, value.get());
            }
        }

        public Optional<E> read(JsonReader in) throws IOException {
            if (in.peek() != JsonToken.NULL) {
                return Optional.ofNullable(this.typeAdapter.read(in));
            }
            in.nextNull();
            return Optional.empty();
        }
    }
}

