/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.inject.guice;

import com.google.inject.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceStageFinder {
    private static final Logger logger = LoggerFactory.getLogger(GuiceStageFinder.class);
    private static final String PROPERTY_NAME = "guice.stage";

    public static Stage getGuiceStage() {
        Stage stage;
        String stageString = System.getProperty(PROPERTY_NAME);
        boolean development = Stage.DEVELOPMENT.name().equals(stageString);
        boolean production = Stage.PRODUCTION.name().equals(stageString);
        if (development || production) {
            stage = development ? Stage.DEVELOPMENT : Stage.PRODUCTION;
            logger.warn("using Guice Stage {} from JVM arg -D{}={}", new Object[]{stage, PROPERTY_NAME, stageString});
        } else if (stageString != null) {
            stage = Stage.PRODUCTION;
            logger.warn("unrecognized JVM arg value -D{}={}, using Guice Stage {}", new Object[]{PROPERTY_NAME, stageString, Stage.PRODUCTION});
        } else {
            stage = Stage.PRODUCTION;
            logger.warn("using default Guice Stage={}", (Object)Stage.PRODUCTION);
        }
        return stage;
    }
}

