/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.inject.guice;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Named;
import java.beans.Introspector;
import java.util.HashMap;
import java.util.Map;

public class GuiceTool {
    public static <T> Map<String, T> getInstancesOfType(Injector injector, Class<T> type) {
        HashMap<String, T> instances = new HashMap<String, T>();
        for (Map.Entry bindingEntry : injector.getAllBindings().entrySet()) {
            Class bindedType = ((Key)bindingEntry.getKey()).getTypeLiteral().getRawType();
            if (!type.isAssignableFrom(bindedType)) continue;
            T instance = type.cast(((Binding)bindingEntry.getValue()).getProvider().get());
            instances.put(GuiceTool.makeBindingName((Binding)bindingEntry.getValue()), instance);
        }
        return instances;
    }

    private static String makeBindingName(Binding<?> binding) {
        if (binding.getKey().getAnnotationType() == null) {
            return Introspector.decapitalize(binding.getProvider().get().getClass().getSimpleName());
        }
        if (binding.getKey().getAnnotationType().equals(Named.class)) {
            return ((Named)binding.getKey().getAnnotation()).value();
        }
        return Introspector.decapitalize(binding.getKey().getAnnotationType().getSimpleName());
    }
}

