/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.pathnode;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class FileSystemNode {
    private final List<FileSystemNode> children = new ArrayList<FileSystemNode>();
    protected FileSystemNode parent;
    protected String value;
    protected boolean isFile;

    public <P extends FileSystemNode> P directory(Supplier<P> childSupplier, String childName) {
        return (P)this.children.stream().filter(child -> child.value.equals(childName)).findAny().map(child -> child).orElseGet(() -> {
            FileSystemNode directoryNode = (FileSystemNode)childSupplier.get();
            directoryNode.parent = this;
            directoryNode.value = childName;
            directoryNode.isFile = false;
            this.children.add(directoryNode);
            return directoryNode;
        });
    }

    public FileSystemNode file(String childName) {
        FileSystemNode fileNode = new FileSystemNode();
        fileNode.parent = this;
        fileNode.value = childName;
        fileNode.isFile = true;
        this.children.add(fileNode);
        return fileNode;
    }

    public String toSlashedStringWithTrailingSlash() {
        if (this.isFile) {
            return this.join("/", "/", "");
        }
        return this.join("/", "/", "/");
    }

    public String toSlashedString() {
        return this.join("/", "/", "");
    }

    public String join(String prefix, String delimiter, String suffix) {
        return this.reverse().stream().map(pathNode -> pathNode.value).collect(Collectors.joining(delimiter, prefix, suffix));
    }

    public Supplier<String> createAndGetSlashedStringWithTrailingSlashSupplier() {
        return () -> {
            this.createDirectoriesIfNeeded(this.getPathWithoutFile());
            return this.toSlashedStringWithTrailingSlash();
        };
    }

    public Supplier<String> createAndGetSlashedStringSupplier() {
        return () -> {
            this.createDirectoriesIfNeeded(this.getPathWithoutFile());
            return this.toSlashedString();
        };
    }

    public String getValue() {
        return this.value;
    }

    public boolean isFileSystemNodeFile() {
        return this.isFile;
    }

    public String getPathWithoutFile() {
        String path = this.toSlashedString();
        if (this.isFile) {
            path = FileSystemNode.getStringBeforeLastOccurrence('/', this.toSlashedString());
        }
        return path;
    }

    private List<FileSystemNode> reverse() {
        ArrayList<FileSystemNode> nodes = new ArrayList<FileSystemNode>();
        FileSystemNode cursor = this;
        while (cursor != null && cursor.value != null) {
            nodes.add(cursor);
            cursor = cursor.parent;
        }
        Collections.reverse(nodes);
        return nodes;
    }

    private void createDirectoriesIfNeeded(String absolutePath) {
        Path mainIndexDirectoryPath = Paths.get(absolutePath, new String[0]);
        try {
            Files.createDirectories(mainIndexDirectoryPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Path does not exist and unable to create it", e);
        }
    }

    public int hashCode() {
        return this.toSlashedString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileSystemNode)) {
            return false;
        }
        FileSystemNode other = (FileSystemNode)obj;
        return this.isFile == other.isFile && Objects.equals(this.toSlashedString(), other.toSlashedString());
    }

    public String toString() {
        throw new RuntimeException("FileSystemNode::toString is unusable to avoid unwanted dependencies. FileSystemNode.value=" + this.value);
    }

    private static String getStringBeforeLastOccurrence(char ch, String sourceString) {
        if (sourceString == null) {
            return null;
        }
        int index = sourceString.lastIndexOf(Character.toString(ch));
        if (index < 0) {
            return "";
        }
        return sourceString.substring(0, index);
    }
}

