/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.pathnode;

import io.datarouter.pathnode.Java11;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class PathNode {
    private final List<PathNode> children = new ArrayList<PathNode>();
    protected PathNode parent;
    protected String value;

    public <P extends PathNode> P branch(Supplier<P> childSupplier, String childName) {
        return (P)this.children.stream().filter(child -> child.value.equals(childName)).findAny().map(child -> child).orElseGet(() -> {
            PathNode child = (PathNode)childSupplier.get();
            child.parent = this;
            child.value = childName;
            this.children.add(child);
            return child;
        });
    }

    public PathNode leaf(String childName) {
        PathNode child = new PathNode();
        child.parent = this;
        child.value = childName;
        this.children.add(child);
        return child;
    }

    public List<PathNode> paths() {
        ArrayList<PathNode> paths = new ArrayList<PathNode>();
        paths.add(this);
        this.children.stream().map(PathNode::paths).forEach(paths::addAll);
        return paths;
    }

    public String[] toStringArray() {
        return (String[])PathNode.nodesAfter(null, this).stream().map(PathNode::getValue).toArray(String[]::new);
    }

    public static String toSlashedString(List<PathNode> nodes, boolean includeLeadingSlash) {
        String prefix = includeLeadingSlash ? "/" : "";
        return PathNode.joinNodes(nodes, prefix, "/", "");
    }

    public String toSlashedString() {
        return this.join("/", "/", "");
    }

    public String toSlashedStringWithTrailingSlash() {
        return this.join("/", "/", "/");
    }

    public String join(String delimiter) {
        return this.join("", delimiter, "");
    }

    public String join(String prefix, String delimiter, String suffix) {
        return PathNode.joinNodes(PathNode.nodesAfter(null, this), prefix, delimiter, suffix);
    }

    public static List<PathNode> nodesAfter(PathNode after, PathNode through) {
        ArrayList<PathNode> nodes = new ArrayList<PathNode>();
        PathNode cursor = through;
        while (cursor != after && cursor != null && cursor.value != null) {
            nodes.add(cursor);
            cursor = cursor.parent;
        }
        Collections.reverse(nodes);
        return nodes;
    }

    public String toSlashedStringAfter(PathNode after, boolean includeLeadingSlash) {
        return PathNode.toSlashedString(PathNode.nodesAfter(after, this), includeLeadingSlash);
    }

    public static boolean isLeaf(PathNode pathNode) {
        return !pathNode.paths().isEmpty();
    }

    public int hashCode() {
        return this.toSlashedString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PathNode)) {
            return false;
        }
        PathNode other = (PathNode)obj;
        return Objects.equals(this.toSlashedString(), other.toSlashedString());
    }

    public String toString() {
        throw new RuntimeException("PathNode::toString is unusable to avoid unwanted dependencies. PathNode.value=" + this.value);
    }

    public String getValue() {
        return this.value;
    }

    public static PathNode parse(String stringPath) {
        Path path = Java11.pathOf(stringPath);
        Iterator<Path> pathParts = path.iterator();
        PathNode pathNode = new PathNode();
        while (pathParts.hasNext()) {
            pathNode = pathNode.branch(PathNode::new, pathParts.next().toString());
        }
        return pathNode;
    }

    private static String joinNodes(List<PathNode> nodes, String prefix, String delimiter, String suffix) {
        return nodes.stream().map(pathNode -> pathNode.value).collect(Collectors.joining(delimiter, prefix, suffix));
    }
}

