/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.ratelimiter;

import io.datarouter.ratelimiter.BaseCacheRateLimiter;
import io.datarouter.ratelimiter.CacheRateLimiterConfig;
import io.datarouter.ratelimiter.storage.BaseTallyDao;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public class BaseTallyCacheRateLimiter
extends BaseCacheRateLimiter {
    private final BaseTallyDao tallyDao;

    public BaseTallyCacheRateLimiter(BaseTallyDao tallyDao, CacheRateLimiterConfig config) {
        super(config);
        this.tallyDao = tallyDao;
    }

    @Override
    protected Long increment(String key) {
        return this.tallyDao.incrementAndGetCount(key, 1, this.getConfig().expiration, Duration.ofMillis(200L));
    }

    @Override
    protected Map<String, Long> readCounts(List<String> keys) {
        return this.tallyDao.getMultiTallyCount(keys, this.getConfig().expiration, Duration.ofMillis(200L));
    }
}

