/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.node;

import io.datarouter.client.redis.RedisClientType;
import io.datarouter.client.redis.client.RedisClientManager;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.codec.BinaryDatabeanCodec;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.read.TallyStorageReader;
import io.datarouter.storage.node.type.physical.base.BasePhysicalNode;
import io.datarouter.storage.tally.TallyKey;
import io.lettuce.core.Value;
import io.lettuce.core.api.async.RedisAsyncCommands;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisReaderNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends BasePhysicalNode<PK, D, F>
implements TallyStorageReader<PK, D> {
    private static final Logger logger = LoggerFactory.getLogger(RedisReaderNode.class);
    protected final ExecutorService executor;
    protected final BinaryDatabeanCodec codec;
    private final RedisClientManager redisClientManager;
    private final ClientId clientId;

    public RedisReaderNode(NodeParams<PK, D, F> params, RedisClientType redisClientType, RedisClientManager redisClientManager, ClientId clientId, ExecutorService executor) {
        super(params, (ClientType)redisClientType);
        this.executor = executor;
        this.codec = new BinaryDatabeanCodec.BinaryDatabeanCodecBuilder().setDatabeanVersion(Optional.ofNullable(params.getSchemaVersion()).orElse(1).intValue()).setAllowNulls(false).setTerminateIntermediateString(true).setTerminateFinalString(true).build();
        this.redisClientManager = redisClientManager;
        this.clientId = clientId;
    }

    public boolean exists(PK key, Config config) {
        try {
            return (Long)this.client().exists((Object[])new byte[][]{this.codec.encode(key)}).get() == 1L;
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
            return false;
        }
    }

    public D get(PK key, Config config) {
        if (key == null) {
            return null;
        }
        byte[] bytes = null;
        try {
            bytes = (byte[])this.client().get((Object)this.codec.encode(key)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
        }
        if (bytes == null) {
            return null;
        }
        try {
            return (D)((Databean)this.codec.decode(this.getFieldInfo().getDatabeanSupplier(), this.getFieldInfo().getFieldByPrefixedName(), bytes));
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public List<D> getMulti(Collection<PK> keys, Config config) {
        if (keys == null || keys.isEmpty()) {
            return List.of();
        }
        List response = new ArrayList();
        try {
            response = (List)this.client().mget((Object[])this.encodeKeys(keys)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
        }
        return Scanner.of(response).include(Value::hasValue).map(Value::getValue).exclude(Objects::isNull).map(bytes -> {
            try {
                return (Databean)this.codec.decode(this.getFieldInfo().getDatabeanSupplier(), this.getFieldInfo().getFieldByPrefixedName(), bytes);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                return null;
            }
        }).list();
    }

    public List<PK> getKeys(Collection<PK> keys, Config config) {
        if (keys == null || keys.isEmpty()) {
            return List.of();
        }
        return Scanner.of(this.getMulti(keys, config)).map(Databean::getKey).list();
    }

    public Optional<Long> findTallyCount(String key, Config config) {
        if (key == null) {
            return Optional.empty();
        }
        byte[] byteTally = null;
        try {
            byteTally = (byte[])this.client().get((Object)this.codec.encode((PrimaryKey)new TallyKey(key))).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
        }
        if (byteTally == null || byteTally.length == 0) {
            return Optional.empty();
        }
        return Optional.ofNullable(byteTally).map(String::new).map(String::trim).map(Long::valueOf);
    }

    public Map<String, Long> getMultiTallyCount(Collection<String> keys, Config config) {
        return Scanner.of(keys).toMap(Function.identity(), key -> this.findTallyCount((String)key).orElse(0L));
    }

    protected byte[][] encodeKeys(Collection<? extends PrimaryKey<?>> pks) {
        return (byte[][])this.codec.encodeMulti(pks).toArray((T[])new byte[pks.size()][]);
    }

    protected RedisAsyncCommands<byte[], byte[]> client() {
        return this.redisClientManager.getClient(this.clientId).async();
    }
}

