/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.redis.client;

import io.datarouter.scanner.Scanner;
import io.datarouter.util.tuple.Pair;
import io.datarouter.util.tuple.Twin;
import io.lettuce.core.KeyValue;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisOps {
    private static final Logger logger = LoggerFactory.getLogger(RedisOps.class);
    private final RedisClusterAsyncCommands<byte[], byte[]> client;

    public RedisOps(RedisClusterAsyncCommands<byte[], byte[]> client) {
        this.client = client;
    }

    public boolean exists(byte[] key) {
        try {
            return (Long)this.client.exists((Object[])new byte[][]{key}).get() == 1L;
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
            return false;
        }
    }

    public Optional<byte[]> find(byte[] key) {
        try {
            return Optional.ofNullable((byte[])this.client.get((Object)key).get());
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
            return Optional.empty();
        }
    }

    public Scanner<KeyValue<byte[], byte[]>> mget(List<byte[]> keys) {
        byte[][] keysArray = (byte[][])keys.toArray((T[])new byte[keys.size()][]);
        try {
            return Scanner.of((Iterable)((Iterable)this.client.mget((Object[])keysArray).get()));
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
            return Scanner.empty();
        }
    }

    public void set(Twin<byte[]> kv) {
        try {
            this.client.set((Object)((byte[])kv.getLeft()), (Object)((byte[])kv.getRight())).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
        }
    }

    public void psetex(Twin<byte[]> kv, long ttlMs) {
        try {
            this.client.psetex((Object)((byte[])kv.getLeft()), ttlMs, (Object)((byte[])kv.getRight())).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
        }
    }

    public void mset(List<Twin<byte[]>> kvs) {
        try {
            this.client.mset(Scanner.of(kvs).toMap(Pair::getLeft, Pair::getRight)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
        }
    }

    public void del(byte[] key) {
        try {
            this.client.del((Object[])new byte[][]{key}).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
        }
    }

    public void del(List<byte[]> keys) {
        try {
            byte[][] keysArray = (byte[][])keys.toArray((T[])new byte[keys.size()][]);
            this.client.del((Object[])keysArray).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("", (Throwable)e);
        }
    }
}

