/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.BaseLinkedScanner;
import io.datarouter.scanner.Scanner;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public class DistinctScanner<T, R>
extends BaseLinkedScanner<T, T> {
    private final Function<T, R> mapper;
    private final Set<R> items;

    public DistinctScanner(Scanner<T> input, Function<T, R> mapper) {
        super(input);
        this.mapper = mapper;
        this.items = new HashSet<R>();
    }

    @Override
    protected boolean advanceInternal() {
        while (this.input.advance()) {
            Object item = this.input.current();
            if (!this.items.add(this.mapper.apply(item))) continue;
            this.current = item;
            return true;
        }
        return false;
    }
}

