/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.BaseLinkedScanner;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefetchingScanner<T>
extends BaseLinkedScanner<T, List<T>> {
    private static final Logger logger = LoggerFactory.getLogger(PrefetchingScanner.class);
    private final ExecutorService exec;
    private final int batchSize;
    private Future<List<T>> nextFuture;

    public PrefetchingScanner(Scanner<T> input, ExecutorService exec, int batchSize) {
        super(input);
        this.exec = exec;
        this.batchSize = batchSize;
        this.nextFuture = this.submitNext();
    }

    @Override
    public boolean advanceInternal() {
        if (this.nextFuture == null) {
            this.current = null;
            return false;
        }
        this.current = PrefetchingScanner.get(this.nextFuture);
        this.nextFuture = null;
        if (((List)this.current).isEmpty()) {
            this.current = null;
            return false;
        }
        if (((List)this.current).size() == this.batchSize) {
            this.nextFuture = this.submitNext();
        }
        return true;
    }

    private Future<List<T>> submitNext() {
        return this.exec.submit(() -> this.input.take(this.batchSize));
    }

    @Override
    protected void closeInternal() {
        if (this.nextFuture != null) {
            try {
                this.nextFuture.cancel(true);
            }
            catch (Exception e) {
                logger.warn("scanner exception on nextFuture.cancel", (Throwable)e);
            }
        }
    }

    private static <T> T get(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            future.cancel(true);
            throw new RuntimeException(e);
        }
    }
}

