/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.BaseLinkedScanner;
import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.Random;

public class ShufflingScanner<T>
extends BaseLinkedScanner<T, T> {
    private final Random random = new Random();
    private ArrayList<T> items;
    private int index = 0;

    public ShufflingScanner(Scanner<T> input) {
        super(input);
    }

    @Override
    protected boolean advanceInternal() {
        int numRemaining;
        if (this.items == null) {
            this.items = this.input.collect(ArrayList::new);
        }
        if ((numRemaining = this.items.size() - this.index) == 0) {
            return false;
        }
        int randomLaterIndex = this.index + this.random.nextInt(numRemaining);
        this.current = this.items.get(randomLaterIndex);
        this.items.set(randomLaterIndex, this.items.get(this.index));
        this.items.set(this.index, null);
        ++this.index;
        return true;
    }
}

