/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.EmptyScanner;
import io.datarouter.scanner.Scanner;

public class ArrayScanner<T>
implements Scanner<T> {
    private final T[] array;
    private int index = -1;

    public ArrayScanner(T[] array) {
        this.array = array;
    }

    public static <T> Scanner<T> of(T[] array) {
        return array.length == 0 ? EmptyScanner.singleton() : new ArrayScanner<T>(array);
    }

    @Override
    public boolean advance() {
        ++this.index;
        return this.index < this.array.length;
    }

    @Override
    public T current() {
        return this.array[this.index];
    }
}

