/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.BaseLinkedScanner;
import io.datarouter.scanner.Scanner;
import java.util.Comparator;
import java.util.Objects;

public class ComparableScanner<T>
extends BaseLinkedScanner<T, T>
implements Comparable<Scanner<T>> {
    private final Comparator<? super T> comparator;

    public ComparableScanner(Scanner<T> input, Comparator<? super T> comparator) {
        super(input);
        this.comparator = comparator;
    }

    @Override
    public boolean advanceInternal() {
        if (this.input.advance()) {
            this.current = Objects.requireNonNull(this.input.current());
            return true;
        }
        this.current = null;
        return false;
    }

    @Override
    public int compareTo(Scanner<T> that) {
        return this.comparator.compare(this.current(), that.current());
    }
}

