/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.ParallelMappingScanner;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.scanner.Scanner;
import io.datarouter.scanner.ScannerConsumerFunction;
import io.datarouter.scanner.ScannerPredicateFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class ParallelScanner<T> {
    private final ParallelScannerContext context;
    private final Scanner<T> input;

    public ParallelScanner(ParallelScannerContext context, Scanner<T> input) {
        this.context = context;
        this.input = input;
    }

    public Scanner<T> each(Consumer<? super T> consumer) {
        if (this.context.enabled) {
            return this.map(new ScannerConsumerFunction<T>(consumer));
        }
        return this.input.each(consumer);
    }

    public Scanner<T> exclude(Predicate<? super T> predicate) {
        if (this.context.enabled) {
            return this.map(new ScannerPredicateFunction<T>(predicate)).exclude(result -> result.passes).map(result -> result.item);
        }
        return this.input.exclude(predicate);
    }

    public void forEach(Consumer<? super T> consumer) {
        if (this.context.enabled) {
            this.map(new ScannerConsumerFunction<T>(consumer)).count();
        } else {
            this.input.forEach(consumer);
        }
    }

    public Scanner<T> include(Predicate<? super T> predicate) {
        if (this.context.enabled) {
            return this.map(new ScannerPredicateFunction<T>(predicate)).include(result -> result.passes).map(result -> result.item);
        }
        return this.input.include(predicate);
    }

    public <R> Scanner<R> map(Function<? super T, ? extends R> mapper) {
        if (this.context.enabled) {
            return new ParallelMappingScanner<T, R>(this.input, this.context.allowUnorderedResults, this.context.executor, this.context.numThreads, mapper);
        }
        return this.input.map(mapper);
    }
}

