/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.EmptyScanner;
import io.datarouter.scanner.Scanner;
import java.util.List;

public class RandomAccessScanner<T>
implements Scanner<T> {
    private final List<T> list;
    private int index = -1;

    public RandomAccessScanner(List<T> list) {
        this.list = list;
    }

    public static <T> Scanner<T> of(List<T> list) {
        return list.size() == 0 ? EmptyScanner.singleton() : new RandomAccessScanner<T>(list);
    }

    @Override
    public boolean advance() {
        ++this.index;
        return this.index < this.list.size();
    }

    @Override
    public T current() {
        return this.list.get(this.index);
    }
}

