/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.EmptyScanner;
import io.datarouter.scanner.IteratorScanner;
import io.datarouter.scanner.RandomAccessScanner;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.RandomAccess;

public class IterableScanner {
    public static <T> Scanner<T> of(Iterable<T> iterable) {
        if (iterable instanceof List && iterable instanceof RandomAccess) {
            return RandomAccessScanner.of((List)iterable);
        }
        return IteratorScanner.of(iterable.iterator());
    }

    public static <T> Scanner<T> ofNullable(Iterable<T> iterable) {
        return iterable == null ? EmptyScanner.singleton() : IterableScanner.of(iterable);
    }
}

