/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.BaseScanner;
import java.util.Collection;
import java.util.List;

public abstract class PagingScanner<K, T>
extends BaseScanner<List<T>> {
    protected final int pageSize;

    protected PagingScanner(int pageSize) {
        this.pageSize = pageSize;
    }

    protected abstract K nextParam(T var1);

    protected abstract List<T> nextPage(K var1);

    @Override
    public boolean advance() {
        if (this.current != null && ((List)this.current).size() < this.pageSize) {
            return false;
        }
        T lastSeenItem = PagingScanner.getLast((List)this.current);
        K resumeFrom = this.nextParam(lastSeenItem);
        this.current = this.nextPage(resumeFrom);
        return PagingScanner.notEmpty((Collection)this.current);
    }

    private static <T> boolean notEmpty(Collection<T> collection) {
        return collection != null && !collection.isEmpty();
    }

    private static <T> T getLast(List<T> list) {
        if (PagingScanner.notEmpty(list)) {
            return list.get(list.size() - 1);
        }
        return null;
    }
}

