/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.scanner;

import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class ScannerToGroups<T, K, V, C extends Collection<V>, M extends Map<K, C>>
implements Function<Scanner<T>, M> {
    private final Function<T, K> keyFunction;
    private final Function<T, V> valueFunction;
    private final Supplier<M> mapSupplier;
    private final Supplier<C> collectionSupplier;

    private ScannerToGroups(Function<T, K> keyFunction, Function<T, V> valueFunction, Supplier<M> mapSupplier, Supplier<C> collectionSupplier) {
        this.keyFunction = keyFunction;
        this.valueFunction = valueFunction;
        this.mapSupplier = mapSupplier;
        this.collectionSupplier = collectionSupplier;
    }

    @Override
    public M apply(Scanner<T> scanner) {
        Map map = (Map)this.mapSupplier.get();
        scanner.forEach(item -> {
            K key = this.keyFunction.apply(item);
            Collection collection = map.computeIfAbsent(key, $ -> (Collection)this.collectionSupplier.get());
            V value = this.valueFunction.apply(item);
            collection.add(value);
        });
        return (M)map;
    }

    public static <T, K> Function<Scanner<T>, Map<K, List<T>>> of(Function<T, K> keyFunction) {
        return new ScannerToGroups(keyFunction, Function.identity(), HashMap::new, ArrayList::new);
    }

    public static <T, K, V> Function<Scanner<T>, Map<K, List<V>>> of(Function<T, K> keyFunction, Function<T, V> valueFunction) {
        return new ScannerToGroups<T, K, V, List, Map>(keyFunction, valueFunction, HashMap::new, ArrayList::new);
    }

    public static <T, K, V, M extends Map<K, List<V>>> Function<Scanner<T>, M> of(Function<T, K> keyFunction, Function<T, V> valueFunction, Supplier<M> mapSupplier) {
        return new ScannerToGroups<T, K, V, List, M>(keyFunction, valueFunction, mapSupplier, ArrayList::new);
    }

    public static <T, K, V, C extends Collection<V>, M extends Map<K, C>> Function<Scanner<T>, M> of(Function<T, K> keyFunction, Function<T, V> valueFunction, Supplier<M> mapSupplier, Supplier<C> collectionSupplier) {
        return new ScannerToGroups<T, K, V, C, M>(keyFunction, valueFunction, mapSupplier, collectionSupplier);
    }
}

