/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.secretweb.storage.oprecord;

import io.datarouter.inject.DatarouterInjector;
import io.datarouter.model.databean.Databean;
import io.datarouter.secret.service.SecretOp;
import io.datarouter.secret.service.SecretOpReason;
import io.datarouter.secret.service.SecretOpRecorder;
import io.datarouter.secret.service.SecretOpRecorderSupplier;
import io.datarouter.secretweb.storage.oprecord.DatarouterSecretOpRecord;
import io.datarouter.secretweb.storage.oprecord.DatarouterSecretOpRecordKey;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseDaoParams;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.util.string.StringTool;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterSecretOpRecordDao
extends BaseDao
implements SecretOpRecorder {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterSecretOpRecordDao.class);
    private final SortedMapStorage<DatarouterSecretOpRecordKey, DatarouterSecretOpRecord> node;

    @Inject
    public DatarouterSecretOpRecordDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterSecretOpRecordDaoParams params) {
        super(datarouter);
        this.node = (SortedMapStorage)nodeFactory.create(params.clientId, DatarouterSecretOpRecord::new, DatarouterSecretOpRecord.DatarouterSecretOpRecordFielder::new).withIsSystemTable(true).buildAndRegister();
    }

    public void recordOp(String namespace, String name, SecretOp secretOp, SecretOpReason reason) {
        String reasonString = reason.toString();
        if (reasonString.length() > 255) {
            logger.warn("SecretOpReason too long: {}. Max length={}", (Object)reasonString, (Object)255);
            reasonString = StringTool.trimToSize((String)reasonString, (int)255);
        }
        this.node.put((Databean)new DatarouterSecretOpRecord(namespace, name, secretOp, reason.type, reasonString));
    }

    @Singleton
    public static class DaoSecretOpRecorderSupplier
    implements SecretOpRecorderSupplier {
        @Inject
        private DatarouterInjector injector;

        public SecretOpRecorder get() {
            return (SecretOpRecorder)this.injector.getInstance(DatarouterSecretOpRecordDao.class);
        }
    }

    public static class DatarouterSecretOpRecordDaoParams
    extends BaseDaoParams {
        public DatarouterSecretOpRecordDaoParams(ClientId clientId) {
            super(clientId);
        }
    }
}

