/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.secretweb.storage.oprecord;

import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.comparable.InstantField;
import io.datarouter.model.field.imp.comparable.InstantFieldKey;
import io.datarouter.model.field.imp.comparable.LongField;
import io.datarouter.model.field.imp.comparable.LongFieldKey;
import io.datarouter.model.key.primary.base.BaseRegularPrimaryKey;
import io.datarouter.util.number.RandomTool;
import java.time.Instant;
import java.util.List;

public class DatarouterSecretOpRecordKey
extends BaseRegularPrimaryKey<DatarouterSecretOpRecordKey> {
    private Instant date;
    private String namespace;
    private String name;
    private Long random;

    public DatarouterSecretOpRecordKey() {
    }

    public DatarouterSecretOpRecordKey(String namespace, String name) {
        this(Instant.now(), namespace, name);
    }

    public DatarouterSecretOpRecordKey(Instant date, String namespace, String name) {
        this.date = date;
        this.namespace = namespace;
        this.name = name;
        this.random = RandomTool.nextPositiveLong();
    }

    public List<Field<?>> getFields() {
        return List.of(new InstantField(FieldKeys.date, this.date), new StringField(FieldKeys.namespace, this.namespace), new StringField(FieldKeys.name, this.name), new LongField(FieldKeys.random, this.random));
    }

    public Instant getDate() {
        return this.date;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespacedName() {
        return String.valueOf(this.namespace) + this.name;
    }

    public Long getRandom() {
        return this.random;
    }

    public static class FieldKeys {
        public static final InstantFieldKey date = new InstantFieldKey("date");
        public static final StringFieldKey namespace = new StringFieldKey("namespace");
        public static final StringFieldKey name = new StringFieldKey("name");
        public static final LongFieldKey random = new LongFieldKey("random");
    }
}

